/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDBIDs;
import elki.database.ids.SetDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.knn.PreprocessorKNNQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.DynamicIndex;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.index.preprocessed.knn.KNNChangeEvent;
import elki.index.preprocessed.knn.KNNListener;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.progress.StepProgress;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import javax.swing.event.EventListenerList;

@Title(value="Materialize kNN Neighborhood preprocessor")
@Description(value="Materializes the k nearest neighbors of objects of a database.")
public class MaterializeKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O>
implements DynamicIndex {
    private static final Logging LOG = Logging.getLogger(MaterializeKNNPreprocessor.class);
    protected final KNNSearcher<DBIDRef> knnQuery;
    protected final EventListenerList listenerList = new EventListenerList();

    public MaterializeKNNPreprocessor(Relation<O> relation, Distance<? super O> distance, int k) {
        super(relation, distance, k);
        this.knnQuery = new QueryBuilder(this.distanceQuery).noCache().kNNByDBID(k);
        assert (!(this.knnQuery instanceof PreprocessorKNNQuery)) : this.knnQuery.toString();
    }

    public MaterializeKNNPreprocessor(Relation<O> relation, DistanceQuery<O> distanceQuery, int k, boolean noopt) {
        super(relation, distanceQuery, k);
        QueryBuilder qb = new QueryBuilder(distanceQuery).noCache();
        this.knnQuery = (noopt ? qb.cheapOnly() : qb).kNNByDBID(k);
        assert (!(this.knnQuery instanceof PreprocessorKNNQuery)) : this.knnQuery.toString();
    }

    @Override
    protected void preprocess() {
        Logging log = this.getLogger();
        this.createStorage();
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)this.relation.getDBIDs());
        if (log.isStatistics()) {
            log.statistics((Statistic)new LongStatistic(this.getClass().getName() + ".k", (long)this.k));
        }
        Duration duration = log.isStatistics() ? log.newDuration(this.getClass().getName() + ".precomputation-time").begin() : null;
        FiniteProgress progress = this.getLogger().isVerbose() ? new FiniteProgress("Materializing k nearest neighbors (k=" + this.k + ")", ids.size(), this.getLogger()) : null;
        boolean ismetric = this.getDistanceQuery().getDistance().isMetric();
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            if (ismetric && this.storage.get((DBIDRef)iter) != null) {
                log.incrementProcessed((AbstractProgress)progress);
            } else {
                KNNList knn = this.knnQuery.getKNN((Object)iter, this.k);
                this.storage.put((DBIDRef)iter, (Object)knn);
                if (ismetric) {
                    DoubleDBIDListIter it = knn.iter();
                    while (it.valid() && it.doubleValue() == 0.0) {
                        this.storage.put((DBIDRef)it, (Object)knn);
                        it.advance();
                    }
                }
                log.incrementProcessed((AbstractProgress)progress);
            }
            iter.advance();
        }
        log.ensureCompleted(progress);
        if (duration != null) {
            log.statistics((Statistic)duration.end());
        }
    }

    public final void insert(DBIDRef id) {
        this.objectsInserted((DBIDs)DBIDUtil.deref((DBIDRef)id));
    }

    public void insertAll(DBIDs ids) {
        if (this.storage == null && ids.size() > 0) {
            this.preprocess();
        } else {
            this.objectsInserted(ids);
        }
    }

    public boolean delete(DBIDRef id) {
        this.objectsRemoved((DBIDs)DBIDUtil.deref((DBIDRef)id));
        return true;
    }

    public void deleteAll(DBIDs ids) {
        this.objectsRemoved(ids);
    }

    protected void objectsInserted(DBIDs ids) {
        Logging log = this.getLogger();
        StepProgress stepprog = log.isVerbose() ? new StepProgress(3) : null;
        ArrayDBIDs aids = DBIDUtil.ensureArray((DBIDs)ids);
        log.beginStep(stepprog, 1, "New insertions ocurred, materialize their new kNNs.");
        DBIDArrayIter iter = aids.iter();
        while (iter.valid()) {
            this.storage.put((DBIDRef)iter, (Object)this.knnQuery.getKNN((Object)iter, this.k));
            iter.advance();
        }
        log.beginStep(stepprog, 2, "New insertions ocurred, update the affected kNNs.");
        ArrayDBIDs rkNN_ids = this.updateKNNsAfterInsertion(ids);
        log.beginStep(stepprog, 3, "New insertions ocurred, inform listeners.");
        this.fireKNNsInserted(ids, (DBIDs)rkNN_ids);
        log.setCompleted(stepprog);
    }

    private ArrayDBIDs updateKNNsAfterInsertion(DBIDs ids) {
        ArrayModifiableDBIDs rkNN_ids = DBIDUtil.newArray();
        ModifiableDBIDs oldids = DBIDUtil.difference((DBIDs)this.relation.getDBIDs(), (DBIDs)ids);
        DBIDIter iter = oldids.iter();
        while (iter.valid()) {
            KNNList kNNs = (KNNList)this.storage.get((DBIDRef)iter);
            double knnDist = kNNs.getKNNDistance();
            KNNHeap heap = null;
            DBIDIter iter2 = ids.iter();
            while (iter2.valid()) {
                double dist = this.distanceQuery.distance((DBIDRef)iter, (DBIDRef)iter2);
                if (dist <= knnDist) {
                    heap = heap != null ? heap : DBIDUtil.newHeap((KNNList)kNNs);
                    heap.insert(dist, (DBIDRef)iter2);
                }
                iter2.advance();
            }
            if (heap != null) {
                kNNs = heap.toKNNList();
                this.storage.put((DBIDRef)iter, (Object)kNNs);
                rkNN_ids.add((DBIDRef)iter);
            }
            iter.advance();
        }
        return rkNN_ids;
    }

    private ArrayDBIDs updateKNNsAfterDeletion(DBIDs ids) {
        SetDBIDs idsSet = DBIDUtil.ensureSet((DBIDs)ids);
        ArrayModifiableDBIDs rkNN_ids = DBIDUtil.newArray();
        DBIDIter iditer = this.relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList kNNs = (KNNList)this.storage.get((DBIDRef)iditer);
            DoubleDBIDListIter it = kNNs.iter();
            while (it.valid()) {
                if (idsSet.contains((DBIDRef)it)) {
                    rkNN_ids.add((DBIDRef)iditer);
                    break;
                }
                it.advance();
            }
            iditer.advance();
        }
        DBIDArrayMIter iter = rkNN_ids.iter();
        while (iter.valid()) {
            this.storage.put((DBIDRef)iter, (Object)this.knnQuery.getKNN((Object)iter, this.k));
            iter.advance();
        }
        return rkNN_ids;
    }

    protected void objectsRemoved(DBIDs ids) {
        Logging log = this.getLogger();
        StepProgress stepprog = log.isVerbose() ? new StepProgress(3) : null;
        log.beginStep(stepprog, 1, "New deletions ocurred, remove their materialized kNNs.");
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.storage.delete((DBIDRef)iter);
            iter.advance();
        }
        log.beginStep(stepprog, 2, "New deletions ocurred, update the affected kNNs.");
        ArrayDBIDs rkNN_ids = this.updateKNNsAfterDeletion(ids);
        log.beginStep(stepprog, 3, "New deletions ocurred, inform listeners.");
        this.fireKNNsRemoved(ids, (DBIDs)rkNN_ids);
        log.setCompleted(stepprog);
    }

    protected void fireKNNsInserted(DBIDs insertions, DBIDs updates) {
        KNNChangeEvent e = new KNNChangeEvent(this, KNNChangeEvent.Type.INSERT, insertions, updates);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KNNListener.class) continue;
            ((KNNListener)listeners[i + 1]).kNNsChanged(e);
        }
    }

    protected void fireKNNsRemoved(DBIDs removals, DBIDs updates) {
        KNNChangeEvent e = new KNNChangeEvent(this, KNNChangeEvent.Type.DELETE, removals, updates);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KNNListener.class) continue;
            ((KNNListener)listeners[i + 1]).kNNsChanged(e);
        }
    }

    public void addKNNListener(KNNListener l) {
        this.listenerList.add(KNNListener.class, l);
    }

    public void removeKNNListener(KNNListener l) {
        this.listenerList.remove(KNNListener.class, l);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        public Factory(int k, Distance<? super O> distance) {
            super(k, distance);
        }

        @Override
        public MaterializeKNNPreprocessor<O> instantiate(Relation<O> relation) {
            MaterializeKNNPreprocessor<O> instance = new MaterializeKNNPreprocessor<O>(relation, this.distance, this.k);
            return instance;
        }

        public static class Par<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Par<O> {
            @Override
            public Factory<O> make() {
                return new Factory(this.k, this.distance);
            }
        }
    }
}

