/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.database.datastore.DataStoreFactory;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDIter;
import elki.database.ids.HashSetDBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="W. Dong, C. Moses, K. Li", title="Efficient k-nearest neighbor graph construction for generic similarity measures", booktitle="Proc. 20th Int. Conf. on World Wide Web (WWW'11)", url="https://doi.org/10.1145/1963405.1963487", bibkey="DBLP:conf/www/DongCL11")
public class NNDescent<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(NNDescent.class);
    private String prefix = this.getClass().getCanonicalName();
    private final RandomFactory rnd;
    private double delta = 0.001;
    private double rho = 1.0;
    private int iterations = 100;
    private boolean noInitialNeighbors;
    private WritableDataStore<KNNHeap> store;

    public NNDescent(Relation<O> relation, Distance<? super O> distance, int k, RandomFactory rnd, double delta, double rho, boolean noInitialNeighbors, int iterations) {
        super(relation, distance, k);
        this.rnd = rnd;
        this.delta = delta;
        this.rho = rho;
        this.noInitialNeighbors = noInitialNeighbors;
        this.iterations = iterations;
    }

    @Override
    protected void preprocess() {
        int iter;
        DBIDs ids = this.relation.getDBIDs();
        long starttime = System.currentTimeMillis();
        IndefiniteProgress progress = LOG.isVerbose() ? new IndefiniteProgress("KNNGraph iteration", LOG) : null;
        int internal_k = this.k - 1;
        this.store = DataStoreFactory.FACTORY.makeStorage(ids, 3, KNNHeap.class);
        WritableDataStore newReverseNeighbors = DataStoreFactory.FACTORY.makeStorage(ids, 3, HashSetModifiableDBIDs.class);
        WritableDataStore oldReverseNeighbors = DataStoreFactory.FACTORY.makeStorage(ids, 3, HashSetModifiableDBIDs.class);
        WritableDataStore sampleNewNeighbors = DataStoreFactory.FACTORY.makeStorage(ids, 3, HashSetModifiableDBIDs.class);
        WritableDataStore flag = DataStoreFactory.FACTORY.makeStorage(ids, 3, HashSetModifiableDBIDs.class);
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            this.store.put((DBIDRef)iditer, (Object)DBIDUtil.newHeap((int)internal_k));
            newReverseNeighbors.put((DBIDRef)iditer, (Object)DBIDUtil.newHashSet((int)internal_k));
            oldReverseNeighbors.put((DBIDRef)iditer, (Object)DBIDUtil.newHashSet((int)internal_k));
            iditer.advance();
        }
        int items = (int)Math.ceil(this.rho * (double)internal_k);
        long counter_all = 0L;
        Random rand = this.rnd.getSingleThreadedRandom();
        DBIDIter iditer2 = ids.iter();
        while (iditer2.valid()) {
            ModifiableDBIDs sampleNew = DBIDUtil.randomSampleExcept((DBIDs)ids, (DBIDRef)iditer2, (int)items, (Random)rand);
            sampleNewNeighbors.put((DBIDRef)iditer2, (Object)DBIDUtil.newHashSet((DBIDs)sampleNew));
            ModifiableDBIDs sampleRev = DBIDUtil.randomSampleExcept((DBIDs)ids, (DBIDRef)iditer2, (int)items, (Random)rand);
            newReverseNeighbors.put((DBIDRef)iditer2, (Object)DBIDUtil.newHashSet((DBIDs)sampleRev));
            flag.put((DBIDRef)iditer2, (Object)DBIDUtil.newHashSet());
            if (!this.noInitialNeighbors) {
                HashSetModifiableDBIDs flags = (HashSetModifiableDBIDs)flag.get((DBIDRef)iditer2);
                DBIDMIter siter = sampleNew.iter();
                while (siter.valid()) {
                    if (this.add((DBIDRef)iditer2, (DBIDRef)siter, this.distanceQuery.distance((DBIDRef)iditer2, (DBIDRef)siter))) {
                        flags.add((DBIDRef)siter);
                    }
                    siter.advance();
                }
                counter_all += (long)sampleNew.size();
            }
            iditer2.advance();
        }
        int size = this.relation.size();
        double rate = 0.0;
        for (iter = 0; iter < this.iterations; ++iter) {
            long counter = 0L;
            DBIDIter iditer3 = this.relation.iterDBIDs();
            while (iditer3.valid()) {
                HashSetModifiableDBIDs newNeighbors = (HashSetModifiableDBIDs)flag.get((DBIDRef)iditer3);
                HashSetModifiableDBIDs oldNeighbors = DBIDUtil.newHashSet();
                KNNHeap heap = (KNNHeap)this.store.get((DBIDRef)iditer3);
                DoubleDBIDIter heapiter = heap.unorderedIterator();
                while (heapiter.valid()) {
                    if (!newNeighbors.contains((DBIDRef)heapiter)) {
                        oldNeighbors.add((DBIDRef)heapiter);
                    }
                    heapiter.advance();
                }
                HashSetModifiableDBIDs sampleNew = (HashSetModifiableDBIDs)sampleNewNeighbors.get((DBIDRef)iditer3);
                HashSetModifiableDBIDs newRev = (HashSetModifiableDBIDs)newReverseNeighbors.get((DBIDRef)iditer3);
                newRev.removeDBIDs((DBIDs)sampleNew);
                this.boundSize(newRev, items);
                HashSetModifiableDBIDs oldRev = (HashSetModifiableDBIDs)oldReverseNeighbors.get((DBIDRef)iditer3);
                oldRev.removeDBIDs((DBIDs)oldNeighbors);
                this.boundSize(oldRev, items);
                counter += (long)this.processNewNeighbors((WritableDataStore<HashSetModifiableDBIDs>)flag, sampleNew, oldNeighbors, newRev, oldRev);
                iditer3.advance();
            }
            counter_all += counter;
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(this.prefix + ".scan-rate", (double)counter_all * 0.5 / (double)((long)size * ((long)size - 1L))));
            }
            int t = this.sampleNew(ids, (WritableDataStore<HashSetModifiableDBIDs>)sampleNewNeighbors, (WritableDataStore<HashSetModifiableDBIDs>)flag, items);
            this.clearAll(ids, (WritableDataStore<HashSetModifiableDBIDs>)newReverseNeighbors);
            this.clearAll(ids, (WritableDataStore<HashSetModifiableDBIDs>)oldReverseNeighbors);
            this.reverse((WritableDataStore<HashSetModifiableDBIDs>)sampleNewNeighbors, (WritableDataStore<HashSetModifiableDBIDs>)newReverseNeighbors, (WritableDataStore<HashSetModifiableDBIDs>)oldReverseNeighbors);
            rate = (double)t / (double)(internal_k * size);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(this.prefix + ".update-rate", rate));
            }
            if ((double)counter < this.delta * (double)internal_k * (double)size) {
                LOG.verbose((CharSequence)"KNNGraph terminated because we performaned delta*k*size distance computations.");
                break;
            }
            if (rate < this.delta) {
                LOG.verbose((CharSequence)"KNNGraph terminated because update rate got smaller than delta.");
                break;
            }
            LOG.incrementProcessed((AbstractProgress)progress);
        }
        if (LOG.isVerbose() && iter == this.iterations) {
            LOG.verbose((CharSequence)"KNNGraph terminated because the maximum number of iterations was reached.");
        }
        LOG.setCompleted(progress);
        this.storage = DataStoreFactory.FACTORY.makeStorage(ids, 30, KNNList.class);
        DBIDIter iditer4 = this.relation.iterDBIDs();
        while (iditer4.valid()) {
            KNNHeap tempHeap = DBIDUtil.newHeap((int)this.k);
            KNNHeap heap = (KNNHeap)this.store.get((DBIDRef)iditer4);
            tempHeap.insert(0.0, (DBIDRef)iditer4);
            DoubleDBIDIter heapiter = heap.unorderedIterator();
            while (heapiter.valid()) {
                tempHeap.insert(heapiter.doubleValue(), (DBIDRef)heapiter);
                heapiter.advance();
            }
            this.storage.put((DBIDRef)iditer4, (Object)tempHeap.toKNNList());
            iditer4.advance();
        }
        long end = System.currentTimeMillis();
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new LongStatistic(this.prefix + ".construction-time.ms", end - starttime));
        }
    }

    private void clearAll(DBIDs ids, WritableDataStore<HashSetModifiableDBIDs> sets) {
        DBIDIter it = ids.iter();
        while (it.valid()) {
            ((HashSetModifiableDBIDs)sets.get((DBIDRef)it)).clear();
            it.advance();
        }
    }

    private void boundSize(HashSetModifiableDBIDs set, int items) {
        if (set.size() > items) {
            ModifiableDBIDs sample = DBIDUtil.randomSample((DBIDs)set, (int)items, (RandomFactory)this.rnd);
            set.clear().addDBIDs((DBIDs)sample);
        }
    }

    private int processNewNeighbors(WritableDataStore<HashSetModifiableDBIDs> flag, HashSetModifiableDBIDs newFwd, HashSetModifiableDBIDs oldFwd, HashSetModifiableDBIDs newRev, HashSetModifiableDBIDs oldRev) {
        DBIDMIter niter2;
        int counter = 0;
        if (!newFwd.isEmpty()) {
            DBIDMIter sniter = newFwd.iter();
            while (sniter.valid()) {
                niter2 = newFwd.iter();
                while (niter2.valid()) {
                    if (DBIDUtil.compare((DBIDRef)sniter, (DBIDRef)niter2) < 0) {
                        this.addpair(flag, (DBIDRef)sniter, (DBIDRef)niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                niter2 = oldFwd.iter();
                while (niter2.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)sniter, (DBIDRef)niter2)) {
                        this.addpair(flag, (DBIDRef)sniter, (DBIDRef)niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                sniter.advance();
            }
        }
        if (!newRev.isEmpty()) {
            DBIDMIter nriter = newRev.iter();
            while (nriter.valid()) {
                niter2 = newRev.iter();
                while (niter2.valid()) {
                    if (DBIDUtil.compare((DBIDRef)nriter, (DBIDRef)niter2) < 0) {
                        this.addpair(flag, (DBIDRef)nriter, (DBIDRef)niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                niter2 = oldRev.iter();
                while (niter2.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)nriter, (DBIDRef)niter2)) {
                        this.addpair(flag, (DBIDRef)nriter, (DBIDRef)niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                nriter.advance();
            }
        }
        if (!newFwd.isEmpty()) {
            DBIDMIter sniter2 = newFwd.iter();
            while (sniter2.valid()) {
                niter2 = oldRev.iter();
                while (niter2.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)sniter2, (DBIDRef)niter2)) {
                        this.addpair(flag, (DBIDRef)sniter2, (DBIDRef)niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                niter2 = newRev.iter();
                while (niter2.valid()) {
                    if (DBIDUtil.compare((DBIDRef)sniter2, (DBIDRef)niter2) < 0) {
                        this.addpair(flag, (DBIDRef)sniter2, (DBIDRef)niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                sniter2.advance();
            }
        }
        if (!newRev.isEmpty() && !oldFwd.isEmpty()) {
            DBIDMIter niter = oldFwd.iter();
            while (niter.valid()) {
                niter2 = newRev.iter();
                while (niter2.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)niter, (DBIDRef)niter2)) {
                        this.addpair(flag, (DBIDRef)niter, (DBIDRef)niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                niter.advance();
            }
        }
        return counter;
    }

    private boolean add(DBIDRef cur, DBIDRef cand, double distance) {
        KNNHeap neighbors = (KNNHeap)this.store.get(cur);
        if (neighbors.contains(cand)) {
            return false;
        }
        double newKDistance = neighbors.insert(distance, cand);
        return distance <= newKDistance;
    }

    private void addpair(WritableDataStore<HashSetModifiableDBIDs> newNeighbors, DBIDRef o1, DBIDRef o2) {
        double distance = this.distanceQuery.distance(o1, o2);
        if (this.add(o1, o2, distance)) {
            ((HashSetModifiableDBIDs)newNeighbors.get(o1)).add(o2);
        }
        if (this.add(o2, o1, distance)) {
            ((HashSetModifiableDBIDs)newNeighbors.get(o2)).add(o1);
        }
    }

    private int sampleNew(DBIDs ids, WritableDataStore<HashSetModifiableDBIDs> sampleNewNeighbors, WritableDataStore<HashSetModifiableDBIDs> newNeighborHash, int items) {
        int t = 0;
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            KNNHeap realNeighbors = (KNNHeap)this.store.get((DBIDRef)iditer);
            HashSetModifiableDBIDs newNeighbors = (HashSetModifiableDBIDs)newNeighborHash.get((DBIDRef)iditer);
            HashSetModifiableDBIDs realNewNeighbors = ((HashSetModifiableDBIDs)sampleNewNeighbors.get((DBIDRef)iditer)).clear();
            DoubleDBIDIter heapiter = realNeighbors.unorderedIterator();
            while (heapiter.valid()) {
                if (newNeighbors.contains((DBIDRef)heapiter)) {
                    realNewNeighbors.add((DBIDRef)heapiter);
                    ++t;
                }
                heapiter.advance();
            }
            this.boundSize(realNewNeighbors, items);
            newNeighbors.removeDBIDs((DBIDs)realNewNeighbors);
            newNeighborHash.put((DBIDRef)iditer, (Object)newNeighbors);
            iditer.advance();
        }
        return t;
    }

    private void reverse(WritableDataStore<HashSetModifiableDBIDs> sampleNewHash, WritableDataStore<HashSetModifiableDBIDs> newReverseNeighbors, WritableDataStore<HashSetModifiableDBIDs> oldReverseNeighbors) {
        DBIDIter iditer = this.relation.iterDBIDs();
        while (iditer.valid()) {
            KNNHeap heap = (KNNHeap)this.store.get((DBIDRef)iditer);
            HashSetDBIDs newNeighbors = (HashSetDBIDs)sampleNewHash.get((DBIDRef)iditer);
            DoubleDBIDIter heapiter = heap.unorderedIterator();
            while (heapiter.valid()) {
                ((HashSetModifiableDBIDs)(newNeighbors.contains((DBIDRef)heapiter) ? newReverseNeighbors : oldReverseNeighbors).get((DBIDRef)heapiter)).add((DBIDRef)iditer);
                heapiter.advance();
            }
            iditer.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 4) != 0 ? null : super.kNNByObject(distanceQuery, maxk, flags);
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        private final RandomFactory rnd;
        private final double delta;
        private final double rho;
        private final boolean noInitialNeighbors;
        private final int iterations;

        public Factory(int k, Distance<? super O> distance, RandomFactory rnd, double delta, double rho, boolean noInitialNeighbors, int iterations) {
            super(k, distance);
            this.rnd = rnd;
            this.delta = delta;
            this.rho = rho;
            this.noInitialNeighbors = noInitialNeighbors;
            this.iterations = iterations;
        }

        @Override
        public NNDescent<O> instantiate(Relation<O> relation) {
            return new NNDescent<O>(relation, this.distance, this.k, this.rnd, this.delta, this.rho, this.noInitialNeighbors, this.iterations);
        }

        public static class Par<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Par<O> {
            public static final OptionID SEED_ID = new OptionID("knngraph.seed", "The random number seed.");
            public static final OptionID DELTA_ID = new OptionID("knngraph.delta", "The early termination parameter.");
            public static final OptionID RHO_ID = new OptionID("knngraph.rho", "The sample rate parameter");
            public static final OptionID INITIAL_ID = new OptionID("knngraph.no-initial", "Do not use initial neighbors.");
            public static final OptionID ITER_ID = new OptionID("knngraph.maxiter", "maximum number of iterations");
            private RandomFactory rnd;
            private double delta;
            private double rho;
            private boolean noInitialNeighbors;
            private int iterations;

            @Override
            public void configure(Parameterization config) {
                super.configure(config);
                new RandomParameter(SEED_ID).grab(config, x -> {
                    this.rnd = x;
                });
                ((DoubleParameter)new DoubleParameter(DELTA_ID, 0.001).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                    this.delta = x;
                });
                ((DoubleParameter)new DoubleParameter(RHO_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                    this.rho = x;
                });
                new Flag(INITIAL_ID).grab(config, x -> {
                    this.noInitialNeighbors = x;
                });
                ((IntParameter)new IntParameter(ITER_ID, 100).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.iterations = x;
                });
            }

            @Override
            public Factory<O> make() {
                return new Factory(this.k, this.distance, this.rnd, this.delta, this.rho, this.noInitialNeighbors, this.iterations);
            }
        }
    }
}

