/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.data.NumberVector;
import elki.data.projection.random.RandomProjectionFamily;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.index.IndexFactory;
import elki.index.KNNIndex;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Statistic;
import elki.math.Mean;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Fast and Scalable Outlier Detection with Approximate Nearest Neighbor Ensembles", booktitle="Proc. 20th Int. Conf. Database Systems for Advanced Applications (DASFAA 2015)", url="https://doi.org/10.1007/978-3-319-18123-3_2", bibkey="DBLP:conf/dasfaa/SchubertZK15")
public class NaiveProjectedKNNPreprocessor<O extends NumberVector>
implements KNNIndex<O> {
    protected final Relation<O> relation;
    private static final Logging LOG = Logging.getLogger(NaiveProjectedKNNPreprocessor.class);
    final double window;
    final int projections;
    WritableDataStore<int[]> positions = null;
    Mean mean = new Mean();
    RandomProjectionFamily proj;
    Random random;
    List<ModifiableDoubleDBIDList> projected;

    public NaiveProjectedKNNPreprocessor(Relation<O> relation, double window, int projections, RandomProjectionFamily proj, Random random) {
        this.relation = relation;
        this.window = window;
        this.projections = projections;
        this.proj = proj;
        this.random = random;
    }

    public void initialize() {
        if (this.positions != null) {
            throw new UnsupportedOperationException("Preprocessor already ran.");
        }
        if (this.relation.size() > 0) {
            this.preprocess();
        }
    }

    protected void preprocess() {
        int j;
        Object v;
        DBIDIter iditer;
        long starttime = System.nanoTime();
        int size = this.relation.size();
        int idim = RelationUtil.dimensionality(this.relation);
        int odim = this.projections > 0 ? this.projections : idim;
        this.projected = new ArrayList<ModifiableDoubleDBIDList>(odim);
        for (int j2 = 0; j2 < odim; ++j2) {
            this.projected.add(DBIDUtil.newDistanceDBIDList((int)size));
        }
        if (this.proj == null) {
            int[] permutation = NaiveProjectedKNNPreprocessor.range(0, idim);
            if (odim < idim) {
                NaiveProjectedKNNPreprocessor.randomPermutation(permutation, this.random);
            }
            iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                v = (NumberVector)this.relation.get((DBIDRef)iditer);
                for (j = 0; j < odim; ++j) {
                    this.projected.get(j).add(v.doubleValue(permutation[j]), (DBIDRef)iditer);
                }
                iditer.advance();
            }
        } else {
            RandomProjectionFamily.Projection mat = this.proj.generateProjection(idim, odim);
            iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                v = mat.project((NumberVector)this.relation.get((DBIDRef)iditer));
                for (j = 0; j < odim; ++j) {
                    this.projected.get(j).add((double)v[j], (DBIDRef)iditer);
                }
                iditer.advance();
            }
        }
        for (int j3 = 0; j3 < odim; ++j3) {
            this.projected.get(j3).sort();
        }
        this.positions = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)3, int[].class);
        for (int cnum = 0; cnum < odim; ++cnum) {
            DoubleDBIDListMIter it = this.projected.get(cnum).iter();
            int i = 0;
            while (it.valid()) {
                int[] data;
                if (cnum == 0) {
                    data = new int[odim];
                    this.positions.put((DBIDRef)it, (Object)data);
                } else {
                    data = (int[])this.positions.get((DBIDRef)it);
                }
                data[cnum] = i++;
                it.advance();
            }
        }
        long end = System.nanoTime();
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)("SFC preprocessor took " + (double)(end - starttime) / 1000000.0 + " milliseconds."));
        }
    }

    public static int[] range(int start, int end) {
        int[] out = new int[end - start];
        int i = 0;
        int j = start;
        while (j < end) {
            out[i] = j++;
            ++i;
        }
        return out;
    }

    public static int[] randomPermutation(int[] out, Random random) {
        for (int i = out.length - 1; i > 0; --i) {
            int ri = random.nextInt(i + 1);
            int tmp = out[ri];
            out[ri] = out[i];
            out[i] = tmp;
        }
        return out;
    }

    public void logStatistics() {
        LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getCanonicalName() + ".distance-computations-per-k", this.mean.getMean()));
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    public KNNSearcher<DBIDRef> kNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 4) != 0 ? null : new NaiveProjectedKNNQuery(distanceQuery);
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V> {
        double window;
        int projections;
        RandomProjectionFamily proj;
        RandomFactory random;

        public Factory(double window, int projections, RandomProjectionFamily proj, RandomFactory random) {
            this.window = window;
            this.projections = projections;
            this.proj = proj;
            this.random = random;
        }

        public NaiveProjectedKNNPreprocessor<V> instantiate(Relation<V> relation) {
            return new NaiveProjectedKNNPreprocessor<V>(relation, this.window, this.projections, this.proj, this.random.getRandom());
        }

        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Par
        implements Parameterizer {
            public static final OptionID WINDOW_ID = new OptionID("projections.windowmult", "Window size multiplicator.");
            public static final OptionID PROJECTIONS_ID = new OptionID("projections.projections", "Number of projections to use.");
            public static final OptionID PROJECTION_ID = new OptionID("projections.family", "Random projection family to use. The default is to use the original axes.");
            public static final OptionID RANDOM_ID = new OptionID("projections.seed", "Random generator.");
            double window;
            int projections = -1;
            RandomProjectionFamily proj;
            RandomFactory random;

            public void configure(Parameterization config) {
                new DoubleParameter(WINDOW_ID, 10.0).grab(config, x -> {
                    this.window = x;
                });
                ((IntParameter)((IntParameter)new IntParameter(PROJECTIONS_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.projections = x;
                });
                new ObjectParameter(PROJECTION_ID, RandomProjectionFamily.class).setOptional(true).grab(config, x -> {
                    this.proj = x;
                });
                new RandomParameter(RANDOM_ID).grab(config, x -> {
                    this.random = x;
                });
            }

            public Factory<?> make() {
                return new Factory(this.window, this.projections, this.proj, this.random);
            }
        }
    }

    protected class NaiveProjectedKNNQuery
    implements KNNSearcher<DBIDRef> {
        DistanceQuery<O> distq;

        public NaiveProjectedKNNQuery(DistanceQuery<O> distanceQuery) {
            this.distq = distanceQuery;
        }

        public KNNList getKNN(DBIDRef id, int k) {
            int wsize = (int)Math.ceil(NaiveProjectedKNNPreprocessor.this.window * (double)k);
            HashSetModifiableDBIDs cands = DBIDUtil.newHashSet((int)(2 * wsize * NaiveProjectedKNNPreprocessor.this.projected.size()));
            int[] posi = (int[])NaiveProjectedKNNPreprocessor.this.positions.get(id);
            for (int i = 0; i < posi.length; ++i) {
                DoubleDBIDListMIter it = NaiveProjectedKNNPreprocessor.this.projected.get(i).iter();
                it.seek(Math.max(0, posi[i] - wsize));
                for (int j = wsize << 1; j >= 0 && it.valid(); --j) {
                    cands.add((DBIDRef)it);
                    it.advance();
                }
            }
            int distc = 0;
            KNNHeap heap = DBIDUtil.newHeap((int)k);
            NumberVector vec = (NumberVector)NaiveProjectedKNNPreprocessor.this.relation.get(id);
            DBIDMIter iter = cands.iter();
            while (iter.valid()) {
                heap.insert(this.distq.distance((Object)vec, (DBIDRef)iter), (DBIDRef)iter);
                ++distc;
                iter.advance();
            }
            NaiveProjectedKNNPreprocessor.this.mean.put((double)distc / (double)k);
            return heap.toKNNList();
        }
    }
}

