/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.database.datastore.DataStoreUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDPair;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MeanVariance;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;

@Title(value="Partitioning Approximate kNN Preprocessor")
@Description(value="Caterializes the (approximate) k nearest neighbors of objects of a database by partitioning and only computing kNN within each partition.")
public class PartitionApproximationMaterializeKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(PartitionApproximationMaterializeKNNPreprocessor.class);
    private final int partitions;
    private final RandomFactory rnd;

    public PartitionApproximationMaterializeKNNPreprocessor(Relation<O> relation, Distance<? super O> distance, int k, int partitions, RandomFactory rnd) {
        super(relation, distance, k);
        this.partitions = partitions;
        this.rnd = rnd;
    }

    @Override
    protected void preprocess() {
        DistanceQuery distanceQuery = new QueryBuilder(this.relation, this.distance).distanceQuery();
        this.storage = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)4, KNNList.class);
        MeanVariance ksize = new MeanVariance();
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Approximating nearest neighbor lists to database objects");
        }
        ArrayDBIDs[] parts = DBIDUtil.randomSplit((DBIDs)this.relation.getDBIDs(), (int)this.partitions, (RandomFactory)this.rnd);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Processing partitions", this.partitions, LOG) : null;
        for (int part = 0; part < this.partitions; ++part) {
            ArrayDBIDs ids = parts[part];
            int size = ids.size();
            Object2DoubleOpenHashMap cache = new Object2DoubleOpenHashMap(size * size * 3 >> 3);
            cache.defaultReturnValue(Double.NaN);
            DBIDArrayIter iter = ids.iter();
            while (iter.valid()) {
                KNNHeap kNN = DBIDUtil.newHeap((int)this.k);
                DBIDArrayIter iter2 = ids.iter();
                while (iter2.valid()) {
                    DBIDPair key = DBIDUtil.newPair((DBIDRef)iter, (DBIDRef)iter2);
                    double d = cache.removeDouble((Object)key);
                    if (d == d) {
                        kNN.insert(d, (DBIDRef)iter2);
                    } else {
                        d = distanceQuery.distance((DBIDRef)iter, (DBIDRef)iter2);
                        kNN.insert(d, (DBIDRef)iter2);
                        key = DBIDUtil.newPair((DBIDRef)iter2, (DBIDRef)iter);
                        cache.put((Object)key, d);
                    }
                    iter2.advance();
                }
                ksize.put((double)kNN.size());
                this.storage.put((DBIDRef)iter, (Object)kNN.toKNNList());
                iter.advance();
            }
            if (LOG.isDebugging() && cache.size() > 0) {
                LOG.warning((CharSequence)("Cache should be empty after each run, but still has " + cache.size() + " elements."));
            }
            LOG.incrementProcessed((AbstractProgress)progress);
        }
        LOG.ensureCompleted(progress);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)("On average, " + ksize.getMean() + " +- " + ksize.getSampleStddev() + " neighbors returned."));
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        int partitions;
        private final RandomFactory rnd;

        public Factory(int k, Distance<? super O> distance, int partitions, RandomFactory rnd) {
            super(k, distance);
            this.partitions = partitions;
            this.rnd = rnd;
        }

        @Override
        public PartitionApproximationMaterializeKNNPreprocessor<O> instantiate(Relation<O> relation) {
            PartitionApproximationMaterializeKNNPreprocessor<O> instance = new PartitionApproximationMaterializeKNNPreprocessor<O>(relation, this.distance, this.k, this.partitions, this.rnd);
            return instance;
        }

        public static class Par<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Par<O> {
            public static final OptionID PARTITIONS_ID = new OptionID("partknn.p", "The number of partitions to use for approximate kNN.");
            public static final OptionID SEED_ID = new OptionID("partknn.seed", "The random number generator seed.");
            protected int partitions = 0;
            private RandomFactory rnd;

            @Override
            public void configure(Parameterization config) {
                super.configure(config);
                ((IntParameter)new IntParameter(PARTITIONS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                    this.partitions = x;
                });
                new RandomParameter(SEED_ID).grab(config, x -> {
                    this.rnd = x;
                });
            }

            @Override
            public Factory<O> make() {
                return new Factory(this.k, this.distance, this.partitions, this.rnd);
            }
        }
    }
}

