/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.database.datastore.DataStoreUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="Arthur Zimek, Matthew Gaudet, Ricardo J. G. B. Campello, J\u00f6rg Sander", title="Subsampling for Efficient and Effective Unsupervised Outlier Detection Ensembles", booktitle="Proc. 19th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining, KDD '13", url="https://doi.org/10.1145/2487575.2487676", bibkey="DBLP:conf/kdd/ZimekGCS13")
public class RandomSampleKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(RandomSampleKNNPreprocessor.class);
    private final double share;
    private final RandomFactory rnd;

    public RandomSampleKNNPreprocessor(Relation<O> relation, Distance<? super O> distance, int k, double share, RandomFactory rnd) {
        super(relation, distance, k);
        this.share = share;
        this.rnd = rnd;
    }

    @Override
    protected void preprocess() {
        DistanceQuery distanceQuery = new QueryBuilder(this.relation, this.distance).distanceQuery();
        this.storage = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)4, KNNList.class);
        FiniteProgress progress = this.getLogger().isVerbose() ? new FiniteProgress("Materializing random-sample k nearest neighbors (k=" + this.k + ")", this.relation.size(), this.getLogger()) : null;
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)this.relation.getDBIDs());
        int samplesize = (int)((double)ids.size() * this.share);
        Random random = this.rnd.getSingleThreadedRandom();
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            KNNHeap kNN = DBIDUtil.newHeap((int)this.k);
            ModifiableDBIDs rsamp = DBIDUtil.randomSample((DBIDs)ids, (int)samplesize, (Random)random);
            DBIDIter iter2 = rsamp.iter();
            while (iter2.valid()) {
                double dist = distanceQuery.distance((DBIDRef)iter, (DBIDRef)iter2);
                kNN.insert(dist, (DBIDRef)iter2);
                iter2.advance();
            }
            this.storage.put((DBIDRef)iter, (Object)kNN.toKNNList());
            this.getLogger().incrementProcessed((AbstractProgress)progress);
            iter.advance();
        }
        this.getLogger().ensureCompleted(progress);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        private final double share;
        private final RandomFactory rnd;

        public Factory(int k, Distance<? super O> distance, double share, RandomFactory rnd) {
            super(k, distance);
            this.share = share;
            this.rnd = rnd;
        }

        @Override
        public RandomSampleKNNPreprocessor<O> instantiate(Relation<O> relation) {
            return new RandomSampleKNNPreprocessor<O>(relation, this.distance, this.k, this.share, this.rnd);
        }

        public static class Par<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Par<O> {
            public static final OptionID SHARE_ID = new OptionID("randomknn.share", "The relative amount of objects to consider for kNN computations.");
            public static final OptionID SEED_ID = new OptionID("randomknn.seed", "The random number seed.");
            private double share = 0.0;
            private RandomFactory rnd;

            @Override
            public void configure(Parameterization config) {
                super.configure(config);
                ((DoubleParameter)((DoubleParameter)new DoubleParameter(SHARE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE)).grab(config, x -> {
                    this.share = x;
                });
                new RandomParameter(SEED_ID).grab(config, x -> {
                    this.rnd = x;
                });
            }

            @Override
            public Factory<O> make() {
                return new Factory(this.k, this.distance, this.share, this.rnd);
            }
        }
    }
}

