/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.data.NumberVector;
import elki.data.projection.random.RandomProjectionFamily;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.index.IndexFactory;
import elki.index.KNNIndex;
import elki.index.preprocessed.knn.SpatialPair;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.Mean;
import elki.math.spacefillingcurves.SpatialSorter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Fast and Scalable Outlier Detection with Approximate Nearest Neighbor Ensembles", booktitle="Proc. 20th Int. Conf. Database Systems for Advanced Applications (DASFAA 2015)", url="https://doi.org/10.1007/978-3-319-18123-3_2", bibkey="DBLP:conf/dasfaa/SchubertZK15")
public class SpacefillingKNNPreprocessor<O extends NumberVector>
implements KNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(SpacefillingKNNPreprocessor.class);
    protected final Relation<O> relation;
    final List<? extends SpatialSorter> curvegen;
    final double window;
    final int variants;
    List<List<SpatialPair<DBID, NumberVector>>> curves = null;
    WritableDataStore<int[]> positions = null;
    Mean mean = new Mean();
    final int odim;
    RandomProjectionFamily proj;
    Random random;

    public SpacefillingKNNPreprocessor(Relation<O> relation, List<? extends SpatialSorter> curvegen, double window, int variants, int odim, RandomProjectionFamily proj, Random random) {
        this.relation = relation;
        this.curvegen = curvegen;
        this.window = window;
        this.variants = variants;
        this.odim = odim;
        this.proj = proj;
        this.random = random;
    }

    public void initialize() {
        if (this.curves != null) {
            throw new UnsupportedOperationException("Preprocessor already ran.");
        }
        if (this.relation.size() > 0) {
            this.preprocess();
        }
    }

    protected void preprocess() {
        long starttime = System.currentTimeMillis();
        int size = this.relation.size();
        int numgen = this.curvegen.size();
        int numcurves = this.variants;
        this.curves = new ArrayList<List<SpatialPair<DBID, NumberVector>>>(numcurves);
        for (int i = 0; i < numcurves; ++i) {
            this.curves.add(new ArrayList(size));
        }
        if (this.proj == null) {
            DBIDIter iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                NumberVector v = (NumberVector)this.relation.get((DBIDRef)iditer);
                SpatialPair<DBID, NumberVector> ref = new SpatialPair<DBID, NumberVector>(DBIDUtil.deref((DBIDRef)iditer), v);
                for (List<SpatialPair<DBID, NumberVector>> curve : this.curves) {
                    curve.add(ref);
                }
                iditer.advance();
            }
            double[] mms = SpatialSorter.computeMinMax((Iterable)this.curves.get(0));
            double extend = 0.0;
            int e = mms.length - 1;
            for (int d2 = 0; d2 < e; d2 += 2) {
                extend = Math.max(extend, mms[d2 + 1] - mms[d2]);
            }
            double[] mmscratch = new double[mms.length];
            int idim = mms.length >>> 1;
            int dim = this.odim < 0 ? idim : Math.min(this.odim, idim);
            int[] permutation = SpacefillingKNNPreprocessor.range(0, idim);
            int[] apermutation = dim != idim ? new int[dim] : permutation;
            for (int j = 0; j < numcurves; ++j) {
                int ctype = numgen > 1 ? this.random.nextInt(numgen) : 0;
                double scale = 1.0 + this.random.nextDouble();
                int e2 = mms.length - 1;
                for (int d2 = 0; d2 < e2; d2 += 2) {
                    mmscratch[d2] = mms[d2] - extend * this.random.nextDouble();
                    mmscratch[d2 + 1] = mmscratch[d2] + extend * scale;
                }
                SpacefillingKNNPreprocessor.randomPermutation(permutation, this.random);
                System.arraycopy(permutation, 0, apermutation, 0, dim);
                this.curvegen.get(ctype).sort(this.curves.get(j), 0, size, mmscratch, apermutation);
            }
        } else {
            int idim = RelationUtil.dimensionality(this.relation);
            int dim = this.odim < 0 ? idim : this.odim;
            int[] permutation = SpacefillingKNNPreprocessor.range(0, dim);
            NumberVector.Factory factory = RelationUtil.getNumberVectorFactory(this.relation);
            double[] mms = new double[this.odim << 1];
            for (int j = 0; j < numcurves; ++j) {
                int d2;
                List<SpatialPair<DBID, NumberVector>> curve = this.curves.get(j);
                RandomProjectionFamily.Projection mat = this.proj.generateProjection(idim, dim);
                int ctype = numgen > 1 ? this.random.nextInt(numgen) : 0;
                for (int d22 = 0; d22 < mms.length; d22 += 2) {
                    mms[d22] = Double.POSITIVE_INFINITY;
                    mms[d22 + 1] = Double.NEGATIVE_INFINITY;
                }
                DBIDIter iditer = this.relation.iterDBIDs();
                while (iditer.valid()) {
                    double[] proj = mat.project((NumberVector)this.relation.get((DBIDRef)iditer));
                    curve.add(new SpatialPair<DBID, NumberVector>(DBIDUtil.deref((DBIDRef)iditer), factory.newNumberVector(proj)));
                    d2 = 0;
                    int d = 0;
                    while (d2 < mms.length) {
                        mms[d2] = Math.min(mms[d2], proj[d]);
                        mms[d2 + 1] = Math.max(mms[d2 + 1], proj[d]);
                        d2 += 2;
                        ++d;
                    }
                    iditer.advance();
                }
                double extend = 0.0;
                for (d2 = 0; d2 < mms.length; d2 += 2) {
                    extend = Math.max(extend, mms[d2 + 1] - mms[d2]);
                }
                double scale = 1.0 + this.random.nextDouble();
                for (int d23 = 0; d23 < mms.length; d23 += 2) {
                    int n = d23;
                    mms[n] = mms[n] - extend * this.random.nextDouble();
                    mms[d23 + 1] = mms[d23] + extend * scale;
                }
                SpacefillingKNNPreprocessor.randomPermutation(permutation, this.random);
                this.curvegen.get(ctype).sort(curve, 0, size, mms, permutation);
            }
        }
        this.positions = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)3, int[].class);
        for (int cnum = 0; cnum < numcurves; ++cnum) {
            Iterator<SpatialPair<DBID, NumberVector>> it = this.curves.get(cnum).iterator();
            int i = 0;
            while (it.hasNext()) {
                int[] data;
                SpatialPair<DBID, NumberVector> r = it.next();
                if (cnum == 0) {
                    data = new int[numcurves];
                    this.positions.put((DBIDRef)r.first, (Object)data);
                } else {
                    data = (int[])this.positions.get((DBIDRef)r.first);
                }
                data[cnum] = i++;
            }
        }
        long end = System.currentTimeMillis();
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new LongStatistic(this.getClass().getCanonicalName() + ".construction-time.ms", end - starttime));
        }
    }

    public static int[] range(int start, int end) {
        int[] out = new int[end - start];
        int i = 0;
        int j = start;
        while (j < end) {
            out[i] = j++;
            ++i;
        }
        return out;
    }

    public static int[] randomPermutation(int[] out, Random random) {
        for (int i = out.length - 1; i > 0; --i) {
            int ri = random.nextInt(i + 1);
            int tmp = out[ri];
            out[ri] = out[i];
            out[i] = tmp;
        }
        return out;
    }

    public void logStatistics() {
        LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getCanonicalName() + ".distance-computations-per-k", this.mean.getMean()));
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    public KNNSearcher<DBIDRef> kNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return (flags & 0x24) != 0 ? null : new SpaceFillingKNNQuery(distanceQuery);
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V> {
        List<? extends SpatialSorter> curvegen;
        double window;
        int variants;
        int odim;
        RandomProjectionFamily proj;
        RandomFactory random;

        public Factory(List<? extends SpatialSorter> curvegen, double window, int variants, int odim, RandomProjectionFamily proj, RandomFactory random) {
            this.curvegen = curvegen;
            this.window = window;
            this.variants = variants;
            this.odim = odim;
            this.proj = proj;
            this.random = random;
        }

        public SpacefillingKNNPreprocessor<V> instantiate(Relation<V> relation) {
            return new SpacefillingKNNPreprocessor<V>(relation, this.curvegen, this.window, this.variants, this.odim, this.proj, this.random.getRandom());
        }

        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Par
        implements Parameterizer {
            public static final OptionID CURVES_ID = new OptionID("sfcknn.curves", "Space filling curve generators to use for kNN approximation.");
            public static final OptionID WINDOW_ID = new OptionID("sfcknn.windowmult", "Window size multiplicator.");
            public static final OptionID VARIANTS_ID = new OptionID("sfcknn.variants", "Number of curve variants to generate.");
            public static final OptionID DIM_ID = new OptionID("sfcknn.dim", "Number of dimensions to use for each curve.");
            public static final OptionID PROJECTION_ID = new OptionID("sfcknn.proj", "Random projection to use.");
            public static final OptionID RANDOM_ID = new OptionID("sfcknn.seed", "Random generator.");
            List<? extends SpatialSorter> curvegen;
            double window;
            int variants;
            int odim = -1;
            RandomProjectionFamily proj;
            RandomFactory random;

            public void configure(Parameterization config) {
                new ObjectListParameter(CURVES_ID, SpatialSorter.class).grab(config, x -> {
                    this.curvegen = x;
                });
                new DoubleParameter(WINDOW_ID, 10.0).grab(config, x -> {
                    this.window = x;
                });
                ((IntParameter)new IntParameter(VARIANTS_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.variants = x;
                });
                ((IntParameter)((IntParameter)new IntParameter(DIM_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.odim = x;
                });
                new ObjectParameter(PROJECTION_ID, RandomProjectionFamily.class).setOptional(true).grab(config, x -> {
                    this.proj = x;
                });
                new RandomParameter(RANDOM_ID).grab(config, x -> {
                    this.random = x;
                });
            }

            public Factory<?> make() {
                return new Factory(this.curvegen, this.window, this.variants, this.odim, this.proj, this.random);
            }
        }
    }

    protected class SpaceFillingKNNQuery
    implements KNNSearcher<DBIDRef> {
        DistanceQuery<O> distq;

        public SpaceFillingKNNQuery(DistanceQuery<O> distanceQuery) {
            this.distq = distanceQuery;
        }

        public KNNList getKNN(DBIDRef id, int k) {
            int wsize = (int)Math.ceil(SpacefillingKNNPreprocessor.this.window * (double)k);
            HashSetModifiableDBIDs cands = DBIDUtil.newHashSet((int)(2 * wsize * SpacefillingKNNPreprocessor.this.curves.size()));
            int[] posi = (int[])SpacefillingKNNPreprocessor.this.positions.get(id);
            for (int i = 0; i < posi.length; ++i) {
                List<SpatialPair<DBID, NumberVector>> curve = SpacefillingKNNPreprocessor.this.curves.get(i);
                int start = Math.max(0, posi[i] - wsize);
                int end = Math.min(posi[i] + wsize + 1, curve.size());
                for (int j = start; j < end; ++j) {
                    cands.add((DBIDRef)curve.get((int)j).first);
                }
            }
            int distc = 0;
            KNNHeap heap = DBIDUtil.newHeap((int)k);
            NumberVector vec = (NumberVector)SpacefillingKNNPreprocessor.this.relation.get(id);
            DBIDMIter iter = cands.iter();
            while (iter.valid()) {
                heap.insert(this.distq.distance((Object)vec, (DBIDRef)iter), (DBIDRef)iter);
                ++distc;
                iter.advance();
            }
            SpacefillingKNNPreprocessor.this.mean.put((double)distc / (double)k);
            return heap.toKNNList();
        }
    }
}

