/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.index.preprocessed.knn.SpatialPair;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.Mean;
import elki.math.spacefillingcurves.SpatialSorter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Fast and Scalable Outlier Detection with Approximate Nearest Neighbor Ensembles", booktitle="Proc. 20th Int. Conf. Database Systems for Advanced Applications (DASFAA 2015)", url="https://doi.org/10.1007/978-3-319-18123-3_2", bibkey="DBLP:conf/dasfaa/SchubertZK15")
public class SpacefillingMaterializeKNNPreprocessor<O extends NumberVector>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(SpacefillingMaterializeKNNPreprocessor.class);
    final List<? extends SpatialSorter> curvegen;
    final double window;
    final int variants;
    Mean mean = new Mean();
    Random random;

    public SpacefillingMaterializeKNNPreprocessor(Relation<O> relation, Distance<? super O> distance, int k, List<? extends SpatialSorter> curvegen, double window, int variants, Random random) {
        super(relation, distance, k);
        this.curvegen = curvegen;
        this.window = window;
        this.variants = variants;
        this.random = random;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void preprocess() {
        void var11_14;
        long starttime = System.currentTimeMillis();
        int size = this.relation.size();
        int numgen = this.curvegen.size();
        int numcurves = numgen * this.variants;
        ArrayList curves = new ArrayList(numcurves);
        for (int i = 0; i < numcurves; ++i) {
            curves.add(new ArrayList(size));
        }
        DBIDIter iditer = this.relation.iterDBIDs();
        while (iditer.valid()) {
            NumberVector v = (NumberVector)this.relation.get((DBIDRef)iditer);
            SpatialPair<DBID, NumberVector> ref = new SpatialPair<DBID, NumberVector>(DBIDUtil.deref((DBIDRef)iditer), v);
            for (List list : curves) {
                list.add(ref);
            }
            iditer.advance();
        }
        double[] mms = SpatialSorter.computeMinMax((Iterable)((Iterable)curves.get(0)));
        double[] mmscratch = new double[mms.length];
        int numdim = mms.length >>> 1;
        int[] permutation = new int[numdim];
        boolean bl = false;
        while (var11_14 < this.variants) {
            int i;
            int e = mms.length - 1;
            for (i = 0; i < e; i += 2) {
                double len = mms[i + 1] - mms[i];
                mmscratch[i] = mms[i] - len * this.random.nextDouble();
                mmscratch[i + 1] = mms[i + 1] + len * this.random.nextDouble();
            }
            for (i = 0; i < numdim; ++i) {
                permutation[i] = i;
            }
            for (i = numdim - 1; i > 0; --i) {
                int ri = this.random.nextInt(i + 1);
                int tmp = permutation[ri];
                permutation[ri] = permutation[i];
                permutation[i] = tmp;
            }
            for (i = 0; i < numgen; ++i) {
                this.curvegen.get(i).sort((List)curves.get(i + numgen * var11_14), 0, size, mmscratch, permutation);
            }
            ++var11_14;
        }
        WritableDataStore writableDataStore = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)3, int[].class);
        for (int cnum = 0; cnum < numcurves; ++cnum) {
            Iterator it = ((List)curves.get(cnum)).iterator();
            int i = 0;
            while (it.hasNext()) {
                int[] data;
                SpatialPair r = (SpatialPair)((Object)it.next());
                if (cnum == 0) {
                    data = new int[numcurves];
                    writableDataStore.put((DBIDRef)r.first, (Object)data);
                } else {
                    data = (int[])writableDataStore.get((DBIDRef)r.first);
                }
                data[cnum] = i++;
            }
        }
        int wsize = (int)Math.ceil(this.window * (double)this.k);
        this.storage = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)4, KNNList.class);
        HashSetModifiableDBIDs cands = DBIDUtil.newHashSet((int)(2 * wsize * numcurves));
        DBIDIter iditer2 = this.relation.iterDBIDs();
        while (iditer2.valid()) {
            cands.clear();
            int[] posi = (int[])writableDataStore.get((DBIDRef)iditer2);
            for (int i = 0; i < posi.length; ++i) {
                List curve = (List)curves.get(i);
                int start = Math.max(0, posi[i] - wsize);
                int end = Math.min(posi[i] + wsize + 1, curve.size());
                for (int pos = start; pos < end; ++pos) {
                    cands.add((DBIDRef)((SpatialPair)((Object)curve.get((int)pos))).first);
                }
            }
            int distc = 0;
            KNNHeap heap = DBIDUtil.newHeap((int)this.k);
            NumberVector vec = (NumberVector)this.relation.get((DBIDRef)iditer2);
            DBIDMIter iter = cands.iter();
            while (iter.valid()) {
                heap.insert(this.distanceQuery.distance((Object)vec, (DBIDRef)iter), (DBIDRef)iter);
                ++distc;
                iter.advance();
            }
            this.storage.put((DBIDRef)iditer2, (Object)heap.toKNNList());
            this.mean.put((double)distc / (double)this.k);
            iditer2.advance();
        }
        long end = System.currentTimeMillis();
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new LongStatistic(this.getClass().getCanonicalName() + ".construction-time.ms", end - starttime));
        }
    }

    public void logStatistics() {
        LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getCanonicalName() + ".distance-computations-per-k", this.mean.getMean()));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distQ, int maxk, int flags) {
        return (flags & 4) != 0 ? null : super.kNNByObject(distQ, maxk, flags);
    }

    public static class Factory<V extends NumberVector>
    extends AbstractMaterializeKNNPreprocessor.Factory<V> {
        List<? extends SpatialSorter> curvegen;
        double window;
        int variants;
        RandomFactory random;

        public Factory(int k, Distance<? super V> distance, List<? extends SpatialSorter> curvegen, double window, int variants, RandomFactory random) {
            super(k, distance);
            this.curvegen = curvegen;
            this.window = window;
            this.variants = variants;
            this.random = random;
        }

        @Override
        public SpacefillingMaterializeKNNPreprocessor<V> instantiate(Relation<V> relation) {
            return new SpacefillingMaterializeKNNPreprocessor<V>(relation, this.distance, this.k, this.curvegen, this.window, this.variants, this.random.getRandom());
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Par<V extends NumberVector>
        extends AbstractMaterializeKNNPreprocessor.Factory.Par<V> {
            public static final OptionID CURVES_ID = new OptionID("sfcknn.curves", "Space filling curve generators to use for kNN approximation.");
            public static final OptionID WINDOW_ID = new OptionID("sfcknn.windowmult", "Window size multiplicator.");
            public static final OptionID VARIANTS_ID = new OptionID("sfcknn.variants", "Number of curve variants to generate.");
            public static final OptionID RANDOM_ID = new OptionID("sfcknn.seed", "Random generator.");
            List<? extends SpatialSorter> curvegen;
            double window;
            int variants;
            RandomFactory random;

            @Override
            public void configure(Parameterization config) {
                super.configure(config);
                new ObjectListParameter(CURVES_ID, SpatialSorter.class).grab(config, x -> {
                    this.curvegen = x;
                });
                new DoubleParameter(WINDOW_ID, 10.0).grab(config, x -> {
                    this.window = x;
                });
                ((IntParameter)new IntParameter(VARIANTS_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.variants = x;
                });
                new RandomParameter(RANDOM_ID).grab(config, x -> {
                    this.random = x;
                });
            }

            @Override
            public Factory<V> make() {
                return new Factory(this.k, this.distance, this.curvegen, this.window, this.variants, this.random);
            }
        }
    }
}

