/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.snn;

import elki.data.type.TypeInformation;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.index.preprocessed.snn.SharedNearestNeighborIndex;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="Shared Nearest Neighbor Preprocessor")
@Description(value="Computes the k nearest neighbors of objects of a certain database.")
public class SharedNearestNeighborPreprocessor<O>
implements SharedNearestNeighborIndex<O> {
    private static final Logging LOG = Logging.getLogger(SharedNearestNeighborPreprocessor.class);
    protected int numberOfNeighbors;
    protected Distance<O> distance;
    protected WritableDataStore<ArrayDBIDs> storage = null;
    protected Relation<O> relation;

    public SharedNearestNeighborPreprocessor(Relation<O> relation, int numberOfNeighbors, Distance<O> distance) {
        this.relation = relation;
        this.distance = distance;
        this.numberOfNeighbors = numberOfNeighbors;
    }

    public void initialize() {
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Assigning nearest neighbor lists to database objects");
        }
        this.storage = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)3, ArrayDBIDs.class);
        KNNSearcher knnquery = new QueryBuilder(this.relation, this.distance).kNNByDBID(this.numberOfNeighbors);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("assigning nearest neighbor lists", this.relation.size(), LOG) : null;
        DBIDIter iditer = this.relation.iterDBIDs();
        while (iditer.valid()) {
            ArrayModifiableDBIDs neighbors = DBIDUtil.newArray((int)this.numberOfNeighbors);
            KNNList kNN = knnquery.getKNN((Object)iditer, this.numberOfNeighbors);
            DBIDIter iter = kNN.iter();
            while (iter.valid()) {
                neighbors.add((DBIDRef)iter);
                if (neighbors.size() >= this.numberOfNeighbors) break;
                iter.advance();
            }
            neighbors.sort();
            this.storage.put((DBIDRef)iditer, (Object)neighbors);
            LOG.incrementProcessed((AbstractProgress)progress);
            iditer.advance();
        }
        LOG.ensureCompleted(progress);
    }

    @Override
    public ArrayDBIDs getNearestNeighborSet(DBIDRef objid) {
        if (this.storage == null) {
            this.initialize();
        }
        return (ArrayDBIDs)this.storage.get(objid);
    }

    @Override
    public int getNumberOfNeighbors() {
        return this.numberOfNeighbors;
    }

    public static class Factory<O>
    implements SharedNearestNeighborIndex.Factory<O> {
        public static final OptionID NUMBER_OF_NEIGHBORS_ID = new OptionID("sharedNearestNeighbors", "number of nearest neighbors to consider (at least 1)");
        public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("SNNDistance", "the distance function to asses the nearest neighbors");
        protected int numberOfNeighbors;
        protected Distance<O> distanceFunction;

        public Factory(int numberOfNeighbors, Distance<O> distance) {
            this.numberOfNeighbors = numberOfNeighbors;
            this.distanceFunction = distance;
        }

        @Override
        public SharedNearestNeighborPreprocessor<O> instantiate(Relation<O> relation) {
            return new SharedNearestNeighborPreprocessor<O>(relation, this.numberOfNeighbors, this.distanceFunction);
        }

        @Override
        public int getNumberOfNeighbors() {
            return this.numberOfNeighbors;
        }

        public TypeInformation getInputTypeRestriction() {
            return this.distanceFunction.getInputTypeRestriction();
        }

        public static class Par<O>
        implements Parameterizer {
            protected int numberOfNeighbors;
            protected Distance<O> distanceFunction;

            public void configure(Parameterization config) {
                ((IntParameter)new IntParameter(NUMBER_OF_NEIGHBORS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                    this.numberOfNeighbors = x;
                });
                new ObjectParameter(DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                    this.distanceFunction = x;
                });
            }

            public Factory<O> make() {
                return new Factory<O>(this.numberOfNeighbors, this.distanceFunction);
            }
        }
    }
}

