/*
 * Decompiled with CFR 0.152.
 */
package elki.similarity;

import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.index.Index;
import elki.index.preprocessed.snn.SharedNearestNeighborIndex;
import elki.index.preprocessed.snn.SharedNearestNeighborPreprocessor;
import elki.similarity.AbstractIndexBasedSimilarity;
import elki.similarity.NormalizedSimilarity;
import elki.similarity.Similarity;
import elki.utilities.optionhandling.parameterization.Parameterization;

public class FractionalSharedNearestNeighborSimilarity<O>
extends AbstractIndexBasedSimilarity<O, SharedNearestNeighborIndex.Factory<O>>
implements NormalizedSimilarity<O> {
    public FractionalSharedNearestNeighborSimilarity(SharedNearestNeighborIndex.Factory<O> indexFactory) {
        super(indexFactory);
    }

    public <T extends O> Instance<T> instantiate(Relation<T> database) {
        Index indexi = ((SharedNearestNeighborIndex.Factory)this.indexFactory).instantiate((Relation)database);
        return new Instance<T>(database, indexi, this);
    }

    public static class Par<O>
    extends AbstractIndexBasedSimilarity.Par<SharedNearestNeighborIndex.Factory<O>> {
        public void configure(Parameterization config) {
            super.configure(config);
            this.configIndexFactory(config, SharedNearestNeighborIndex.Factory.class, SharedNearestNeighborPreprocessor.Factory.class);
        }

        public FractionalSharedNearestNeighborSimilarity<O> make() {
            return new FractionalSharedNearestNeighborSimilarity((SharedNearestNeighborIndex.Factory)this.factory);
        }
    }

    public static class Instance<T>
    extends AbstractIndexBasedSimilarity.Instance<T, SharedNearestNeighborIndex<T>> {
        private FractionalSharedNearestNeighborSimilarity<? super T> similarityFunction;

        public Instance(Relation<T> database, SharedNearestNeighborIndex<T> preprocessor, FractionalSharedNearestNeighborSimilarity<? super T> similarityFunction) {
            super(database, preprocessor);
            this.similarityFunction = similarityFunction;
        }

        protected static int countSharedNeighbors(DBIDs neighbors1, DBIDs neighbors2) {
            int intersection = 0;
            DBIDIter iter1 = neighbors1.iter();
            DBIDIter iter2 = neighbors2.iter();
            while (iter1.valid() && iter2.valid()) {
                int comp = DBIDUtil.compare((DBIDRef)iter1, (DBIDRef)iter2);
                if (comp == 0) {
                    ++intersection;
                    iter1.advance();
                    iter2.advance();
                    continue;
                }
                if (comp < 0) {
                    iter1.advance();
                    continue;
                }
                iter2.advance();
            }
            return intersection;
        }

        public double similarity(DBIDRef id1, DBIDRef id2) {
            ArrayDBIDs neighbors1 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id1);
            ArrayDBIDs neighbors2 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id2);
            int intersection = Instance.countSharedNeighbors((DBIDs)neighbors1, (DBIDs)neighbors2);
            return (double)intersection / (double)((SharedNearestNeighborIndex)this.index).getNumberOfNeighbors();
        }

        public Similarity<? super T> getSimilarity() {
            return this.similarityFunction;
        }
    }
}

