/*
 * Decompiled with CFR 0.152.
 */
package elki.similarity;

import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.index.Index;
import elki.index.preprocessed.snn.SharedNearestNeighborIndex;
import elki.index.preprocessed.snn.SharedNearestNeighborPreprocessor;
import elki.similarity.AbstractIndexBasedSimilarity;
import elki.similarity.Similarity;
import elki.utilities.optionhandling.parameterization.Parameterization;

public class SharedNearestNeighborSimilarity<O>
extends AbstractIndexBasedSimilarity<O, SharedNearestNeighborIndex.Factory<O>> {
    public SharedNearestNeighborSimilarity(SharedNearestNeighborIndex.Factory<O> indexFactory) {
        super(indexFactory);
    }

    protected static int countSharedNeighbors(DBIDs neighbors1, DBIDs neighbors2) {
        int intersection = 0;
        DBIDIter iter1 = neighbors1.iter();
        DBIDIter iter2 = neighbors2.iter();
        while (iter1.valid() && iter2.valid()) {
            int comp = DBIDUtil.compare((DBIDRef)iter1, (DBIDRef)iter2);
            if (comp == 0) {
                ++intersection;
                iter1.advance();
                iter2.advance();
                continue;
            }
            if (comp < 0) {
                iter1.advance();
                continue;
            }
            iter2.advance();
        }
        return intersection;
    }

    public <T extends O> Instance<T> instantiate(Relation<T> database) {
        Index indexi = ((SharedNearestNeighborIndex.Factory)this.indexFactory).instantiate((Relation)database);
        return new Instance<T>(database, indexi, this);
    }

    public static class Par<O>
    extends AbstractIndexBasedSimilarity.Par<SharedNearestNeighborIndex.Factory<O>> {
        public void configure(Parameterization config) {
            super.configure(config);
            this.configIndexFactory(config, SharedNearestNeighborIndex.Factory.class, SharedNearestNeighborPreprocessor.Factory.class);
        }

        public SharedNearestNeighborSimilarity<O> make() {
            return new SharedNearestNeighborSimilarity((SharedNearestNeighborIndex.Factory)this.factory);
        }
    }

    public static class Instance<O>
    extends AbstractIndexBasedSimilarity.Instance<O, SharedNearestNeighborIndex<O>> {
        private SharedNearestNeighborSimilarity<? super O> similarityFunction;

        public Instance(Relation<O> database, SharedNearestNeighborIndex<O> preprocessor, SharedNearestNeighborSimilarity<? super O> similarityFunction) {
            super(database, preprocessor);
            this.similarityFunction = similarityFunction;
        }

        public double similarity(DBIDRef id1, DBIDRef id2) {
            ArrayDBIDs neighbors1 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id1);
            ArrayDBIDs neighbors2 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(id2);
            return SharedNearestNeighborSimilarity.countSharedNeighbors((DBIDs)neighbors1, (DBIDs)neighbors2);
        }

        public Similarity<? super O> getSimilarity() {
            return this.similarityFunction;
        }
    }
}

