/*
 * Decompiled with CFR 0.152.
 */
package elki.index.preprocessed.knn;

import elki.data.NumberVector;
import elki.database.datastore.DataStoreUtil;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDPair;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import elki.index.tree.LeafEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MeanVariance;
import elki.result.Metadata;
import elki.utilities.datastructures.iterator.It;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.List;

@Title(value="Spatial Approximation Materialize kNN Preprocessor")
@Description(value="Caterializes the (approximate) k nearest neighbors of objects of a database using a spatial approximation.")
public class SpatialApproximationMaterializeKNNPreprocessor<O extends NumberVector>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(SpatialApproximationMaterializeKNNPreprocessor.class);

    public SpatialApproximationMaterializeKNNPreprocessor(Relation<O> relation, Distance<? super O> distance, int k) {
        super(relation, distance, k);
    }

    protected void preprocess() {
        DistanceQuery distanceQuery = new QueryBuilder(this.relation, this.distance).distanceQuery();
        AbstractRStarTree<?, SpatialEntry, ?> index = this.getSpatialIndex(this.relation);
        this.storage = DataStoreUtil.makeStorage((DBIDs)this.relation.getDBIDs(), (int)4, KNNList.class);
        MeanVariance pagesize = new MeanVariance();
        MeanVariance ksize = new MeanVariance();
        Logging log = this.getLogger();
        if (log.isVerbose()) {
            log.verbose((CharSequence)"Approximating nearest neighbor lists to database objects");
        }
        List<SpatialEntry> leaves = index.getLeaves();
        FiniteProgress progress = log.isVerbose() ? new FiniteProgress("Processing leaf nodes", leaves.size(), log) : null;
        for (SpatialEntry leaf : leaves) {
            AbstractRStarTreeNode node = (AbstractRStarTreeNode)index.getNode(leaf);
            int size = node.getNumEntries();
            pagesize.put((double)size);
            if (log.isDebuggingFinest()) {
                log.debugFinest((CharSequence)("NumEntires = " + size));
            }
            ArrayModifiableDBIDs ids = DBIDUtil.newArray((int)size);
            for (int i = 0; i < size; ++i) {
                ids.add((DBIDRef)((LeafEntry)node.getEntry(i)).getDBID());
            }
            Object2DoubleOpenHashMap cache = new Object2DoubleOpenHashMap(size * size * 3 >> 3);
            DBIDArrayMIter id = ids.iter();
            while (id.valid()) {
                KNNHeap kNN = DBIDUtil.newHeap((int)this.k);
                DBIDArrayMIter id2 = ids.iter();
                while (id2.valid()) {
                    DBIDPair key = DBIDUtil.newPair((DBIDRef)id, (DBIDRef)id2);
                    double d = cache.removeDouble((Object)key);
                    if (d == d) {
                        kNN.insert(d, (DBIDRef)id2);
                    } else {
                        d = distanceQuery.distance((DBIDRef)id, (DBIDRef)id2);
                        kNN.insert(d, (DBIDRef)id2);
                        key = DBIDUtil.newPair((DBIDRef)id2, (DBIDRef)id);
                        cache.put((Object)key, d);
                    }
                    id2.advance();
                }
                ksize.put((double)kNN.size());
                this.storage.put((DBIDRef)id, (Object)kNN.toKNNList());
                id.advance();
            }
            if (log.isDebugging() && cache.size() > 0) {
                log.warning((CharSequence)("Cache should be empty after each run, but still has " + cache.size() + " elements."));
            }
            log.incrementProcessed((AbstractProgress)progress);
        }
        log.ensureCompleted(progress);
        if (log.isVerbose()) {
            log.verbose((CharSequence)("Average page size = " + pagesize.getMean() + " +- " + pagesize.getSampleStddev()));
            log.verbose((CharSequence)("On average, " + ksize.getMean() + " +- " + ksize.getSampleStddev() + " neighbors returned."));
        }
    }

    protected AbstractRStarTree<?, SpatialEntry, ?> getSpatialIndex(Relation<O> relation) {
        AbstractRStarTree ret = null;
        It iter = Metadata.hierarchyOf(relation).iterDescendants().filter(AbstractRStarTree.class);
        while (iter.valid()) {
            if (ret != null) {
                throw new IllegalStateException("More than one spatial index found - this is not supported!");
            }
            ret = (AbstractRStarTree)((Object)iter.get());
            iter.advance();
        }
        if (ret == null) {
            throw new IllegalStateException("No spatial index found!");
        }
        return ret;
    }

    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory
    extends AbstractMaterializeKNNPreprocessor.Factory<NumberVector> {
        public Factory(int k, Distance<? super NumberVector> distance) {
            super(k, distance);
        }

        public SpatialApproximationMaterializeKNNPreprocessor<NumberVector> instantiate(Relation<NumberVector> relation) {
            return new SpatialApproximationMaterializeKNNPreprocessor<NumberVector>(relation, this.distance, this.k);
        }

        public static class Par
        extends AbstractMaterializeKNNPreprocessor.Factory.Par<NumberVector> {
            public Factory make() {
                return new Factory(this.k, (Distance<? super NumberVector>)this.distance);
            }
        }
    }
}

