/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial;

import elki.data.ModifiableHyperBoundingBox;
import elki.data.spatial.SpatialComparable;
import elki.index.tree.DirectoryEntry;
import elki.index.tree.spatial.SpatialEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SpatialDirectoryEntry
implements DirectoryEntry,
SpatialEntry {
    private static final long serialVersionUID = 2L;
    private int id;
    private ModifiableHyperBoundingBox mbr;

    public SpatialDirectoryEntry() {
    }

    public SpatialDirectoryEntry(int id, ModifiableHyperBoundingBox mbr) {
        this.id = id;
        this.mbr = mbr;
    }

    public int getPageID() {
        return this.id;
    }

    public int getDimensionality() {
        return this.mbr.getDimensionality();
    }

    public double getMin(int dimension) {
        return this.mbr.getMin(dimension);
    }

    public double getMax(int dimension) {
        return this.mbr.getMax(dimension);
    }

    public boolean hasMBR() {
        return this.mbr != null;
    }

    public void setMBR(ModifiableHyperBoundingBox mbr) {
        this.mbr = mbr;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        this.mbr.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.mbr = new ModifiableHyperBoundingBox();
        this.mbr.readExternal(in);
    }

    public boolean extendMBR(SpatialComparable responsibleMBR) {
        return this.mbr.extend(responsibleMBR);
    }

    public String toString() {
        return "SpatialDirectoryEntry(" + this.id + " mbr=" + (this.mbr != null ? this.mbr.toString() : null) + ")";
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.id == ((SpatialDirectoryEntry)o).id;
    }

    public int hashCode() {
        return this.id;
    }
}

