/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial;

import elki.data.NumberVector;
import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.index.tree.LeafEntry;
import elki.index.tree.spatial.SpatialEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SpatialPointLeafEntry
implements LeafEntry,
SpatialEntry,
NumberVector {
    private static final long serialVersionUID = 2L;
    private DBID id;
    private double[] values;

    public SpatialPointLeafEntry() {
    }

    public SpatialPointLeafEntry(DBID id, double[] values) {
        this.id = id;
        this.values = values;
    }

    public SpatialPointLeafEntry(DBID id, NumberVector vector) {
        this.id = id;
        int dim = vector.getDimensionality();
        this.values = new double[dim];
        for (int i = 0; i < dim; ++i) {
            this.values[i] = vector.doubleValue(i);
        }
    }

    public DBID getDBID() {
        return this.id;
    }

    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(DBIDUtil.asInteger((DBIDRef)this.id));
        out.writeInt(this.values.length);
        for (double v : this.values) {
            out.writeDouble(v);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = DBIDUtil.importInteger((int)in.read());
        this.values = new double[in.readInt()];
        for (int d = 0; d < this.values.length; ++d) {
            this.values[d] = in.readDouble();
        }
    }

    public double doubleValue(int dimension) {
        return this.values[dimension];
    }

    public long longValue(int dimension) {
        return (long)this.values[dimension];
    }

    public double[] toArray() {
        return (double[])this.values.clone();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && DBIDUtil.equal((DBIDRef)this.id, (DBIDRef)((SpatialPointLeafEntry)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

