/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants;

import elki.data.HyperBoundingBox;
import elki.data.ModifiableHyperBoundingBox;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.index.tree.AbstractNode;
import elki.index.tree.BreadthFirstEnumeration;
import elki.index.tree.IndexTree;
import elki.index.tree.IndexTreePath;
import elki.index.tree.LeafEntry;
import elki.index.tree.Node;
import elki.index.tree.TreeIndexHeader;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.index.tree.spatial.rstarvariants.RTreeSettings;
import elki.index.tree.spatial.rstarvariants.util.NodeArrayAdapter;
import elki.logging.Logging;
import elki.logging.statistics.Counter;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.persistent.PageFile;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.exceptions.AbortException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRStarTree<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry, S extends RTreeSettings>
extends IndexTree<N, E> {
    protected static final boolean EXTRA_INTEGRITY_CHECKS = false;
    protected int height;
    public Statistics statistics = new Statistics();
    E lastInsertedEntry = null;
    protected S settings;

    public AbstractRStarTree(PageFile<N> pagefile, S settings) {
        super(pagefile);
        this.settings = settings;
    }

    protected IndexTreePath<E> findPathToObject(IndexTreePath<E> subtree, SpatialComparable mbr, DBIDRef id) {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.getNode((SpatialEntry)subtree.getEntry());
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                if (!DBIDUtil.equal((DBIDRef)((LeafEntry)node.getEntry(i)).getDBID(), (DBIDRef)id)) continue;
                return new IndexTreePath(subtree, (Object)((SpatialEntry)node.getEntry(i)), i);
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                IndexTreePath<E> path;
                if (!SpatialUtil.intersects((SpatialComparable)((SpatialComparable)node.getEntry(i)), (SpatialComparable)mbr) || (path = this.findPathToObject(new IndexTreePath(subtree, (Object)((SpatialEntry)node.getEntry(i)), i), mbr, id)) == null) continue;
                return path;
            }
        }
        return null;
    }

    public void insertLeaf(E leaf) {
        if (!this.initialized) {
            this.initialize(leaf);
        }
        ((RTreeSettings)this.settings).getOverflowTreatment().reinitialize();
        this.preInsert(leaf);
        this.insertEntry(leaf, this.height);
        this.doExtraIntegrityChecks();
    }

    protected void insertEntry(E entry, int depth) {
        this.lastInsertedEntry = entry;
        IndexTreePath<E> subtree = this.choosePath((IndexTreePath<E>)this.getRootPath(), (SpatialComparable)entry, depth, 1);
        assert (depth == subtree.getPathCount());
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine((CharSequence)("insert at " + subtree));
        }
        AbstractRStarTreeNode parent = (AbstractRStarTreeNode)this.getNode((SpatialEntry)subtree.getEntry());
        parent.addEntry(entry);
        this.writeNode(parent);
        this.adjustTree(subtree);
    }

    protected void deletePath(IndexTreePath<E> deletionPath) {
        AbstractRStarTreeNode leaf = (AbstractRStarTreeNode)this.getNode((SpatialEntry)deletionPath.getParentPath().getEntry());
        int index = deletionPath.getIndex();
        SpatialEntry entry = (SpatialEntry)leaf.getEntry(index);
        leaf.deleteEntry(index);
        this.writeNode(leaf);
        ArrayDeque<AbstractRStarTreeNode> stack = new ArrayDeque<AbstractRStarTreeNode>();
        this.condenseTree(deletionPath.getParentPath(), stack);
        while (!stack.isEmpty()) {
            int i;
            AbstractRStarTreeNode node = (AbstractRStarTreeNode)((Object)stack.pop());
            if (node.isLeaf()) {
                for (i = 0; i < node.getNumEntries(); ++i) {
                    ((RTreeSettings)this.settings).getOverflowTreatment().reinitialize();
                    this.insertEntry((SpatialEntry)node.getEntry(i), this.height);
                }
            } else {
                for (i = 0; i < node.getNumEntries(); ++i) {
                    stack.push((AbstractRStarTreeNode)this.getNode((SpatialEntry)node.getEntry(i)));
                }
            }
            this.deleteNode(node);
        }
        this.postDelete(entry);
        this.doExtraIntegrityChecks();
    }

    public void initializeFromFile(TreeIndexHeader header, PageFile<N> file) {
        super.initializeFromFile(header, file);
        this.height = this.computeHeight();
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine((CharSequence)new StringBuilder(100).append(((Object)((Object)this)).getClass()).append("\n height = ").append(this.height).toString());
        }
    }

    protected void initializeCapacities(E exampleLeaf) {
        ObjectOutputStream oos;
        ByteArrayOutputStream baos;
        int cap;
        try {
            cap = 0;
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            SpatialPointLeafEntry sl = new SpatialPointLeafEntry(DBIDUtil.importInteger((int)0), new double[exampleLeaf.getDimensionality()]);
            while (baos.size() <= this.getPageSize()) {
                sl.writeExternal(oos);
                oos.flush();
                ++cap;
            }
            this.leafCapacity = cap - 1;
        }
        catch (IOException e) {
            throw new AbortException("Error determining page sizes.", (Throwable)e);
        }
        try {
            cap = 0;
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            ModifiableHyperBoundingBox hb = new ModifiableHyperBoundingBox(new double[exampleLeaf.getDimensionality()], new double[exampleLeaf.getDimensionality()]);
            SpatialDirectoryEntry sl = new SpatialDirectoryEntry(0, hb);
            while (baos.size() <= this.getPageSize()) {
                sl.writeExternal(oos);
                oos.flush();
                ++cap;
            }
            this.dirCapacity = cap - 1;
        }
        catch (IOException e) {
            throw new AbortException("Error determining page sizes.", (Throwable)e);
        }
        if (this.dirCapacity <= 2) {
            throw new IllegalArgumentException("Node size of " + this.getPageSize() + " bytes is chosen too small!");
        }
        Logging log = this.getLogger();
        if (this.dirCapacity < 10) {
            log.warning((CharSequence)("Page size is choosen very small! Maximum number of entries in a directory node = " + this.dirCapacity));
        }
        this.dirMinimum = (int)Math.floor((double)this.dirCapacity * ((RTreeSettings)this.settings).relativeMinFill);
        if (this.dirMinimum < 1) {
            this.dirMinimum = 1;
        }
        if (this.leafCapacity <= 2) {
            throw new IllegalArgumentException("Node size of " + this.getPageSize() + " bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            log.warning((CharSequence)("Page size is choosen very small! Maximum number of entries in a leaf node = " + this.leafCapacity));
        }
        this.leafMinimum = (int)Math.floor((double)this.leafCapacity * ((RTreeSettings)this.settings).relativeMinFill);
        if (this.leafMinimum < 1) {
            this.leafMinimum = 1;
        }
    }

    public boolean canBulkLoad() {
        return ((RTreeSettings)this.settings).bulkSplitter != null && !this.initialized;
    }

    protected List<E> createBulkLeafNodes(List<E> objects) {
        int minEntries = this.leafMinimum;
        int maxEntries = this.leafCapacity;
        ArrayList<E> result = new ArrayList<E>();
        List<List<E>> partitions = ((RTreeSettings)this.settings).bulkSplitter.partition(objects, minEntries, maxEntries);
        for (List<E> partition : partitions) {
            AbstractRStarTreeNode leafNode = (AbstractRStarTreeNode)this.createNewLeafNode();
            for (SpatialEntry o : partition) {
                leafNode.addEntry(o);
            }
            this.writeNode(leafNode);
            result.add(this.createNewDirectoryEntry(leafNode));
            if (!this.getLogger().isDebugging()) continue;
            this.getLogger().debugFine((CharSequence)("Created leaf page " + leafNode.getPageID()));
        }
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine((CharSequence)("numDataPages = " + result.size()));
        }
        return result;
    }

    protected abstract void bulkLoad(List<E> var1);

    public final int getHeight() {
        return this.height;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected abstract int computeHeight();

    protected abstract boolean hasOverflow(N var1);

    protected abstract boolean hasUnderflow(N var1);

    protected abstract E createNewDirectoryEntry(N var1);

    protected IndexTreePath<E> createNewRoot(N oldRoot, N newNode) {
        AbstractRStarTreeNode root = (AbstractRStarTreeNode)this.createNewDirectoryNode();
        this.writeNode(root);
        oldRoot.setPageID(root.getPageID());
        if (!oldRoot.isLeaf()) {
            for (int i = 0; i < oldRoot.getNumEntries(); ++i) {
                this.writeNode((AbstractRStarTreeNode)this.getNode((SpatialEntry)oldRoot.getEntry(i)));
            }
        }
        root.setPageID(this.getRootID());
        root.addEntry(this.createNewDirectoryEntry(oldRoot));
        root.addEntry(this.createNewDirectoryEntry(newNode));
        this.writeNode(root);
        this.writeNode((Node)oldRoot);
        this.writeNode((Node)newNode);
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine((CharSequence)("Create new Root: ID=" + root.getPageID() + "\nchild1 " + oldRoot + " " + new HyperBoundingBox(this.createNewDirectoryEntry(oldRoot)) + "\nchild2 " + newNode + " " + new HyperBoundingBox(this.createNewDirectoryEntry(newNode))));
        }
        return new IndexTreePath(null, (Object)((SpatialEntry)this.getRootEntry()), -1);
    }

    protected IndexTreePath<E> containedTest(IndexTreePath<E> subtree, N node, SpatialComparable mbr) {
        SpatialEntry containingEntry = null;
        int index = -1;
        double cEVol = Double.NaN;
        for (int i = 0; i < node.getNumEntries(); ++i) {
            SpatialEntry ei = (SpatialEntry)node.getEntry(i);
            if (!SpatialUtil.contains((SpatialComparable)ei, (SpatialComparable)mbr)) continue;
            if (containingEntry == null) {
                containingEntry = ei;
                index = i;
                continue;
            }
            double tempVol = SpatialUtil.volume((SpatialComparable)ei);
            if (Double.isNaN(cEVol)) {
                cEVol = SpatialUtil.volume((SpatialComparable)containingEntry);
            }
            if (!(tempVol < cEVol)) continue;
            cEVol = tempVol;
            containingEntry = ei;
            index = i;
        }
        return containingEntry == null ? null : new IndexTreePath(subtree, containingEntry, index);
    }

    protected IndexTreePath<E> choosePath(IndexTreePath<E> subtree, SpatialComparable mbr, int depth, int cur) {
        AbstractRStarTreeNode node;
        if (this.getLogger().isDebuggingFiner()) {
            this.getLogger().debugFiner((CharSequence)("node " + subtree + ", depth " + depth));
        }
        if ((node = (AbstractRStarTreeNode)this.getNode((SpatialEntry)subtree.getEntry())) == null) {
            throw new IllegalStateException("Page file did not return node for node id: " + this.getPageID((SpatialEntry)subtree.getEntry()));
        }
        if (node.isLeaf()) {
            return subtree;
        }
        IndexTreePath newSubtree = this.containedTest(subtree, node, mbr);
        if (newSubtree != null) {
            return ++cur == depth ? newSubtree : this.choosePath(newSubtree, mbr, depth, cur);
        }
        AbstractRStarTreeNode childNode = (AbstractRStarTreeNode)this.getNode((SpatialEntry)node.getEntry(0));
        int num = ((RTreeSettings)this.settings).insertionStrategy.choose(node, NodeArrayAdapter.STATIC, mbr, this.height, cur);
        newSubtree = new IndexTreePath(subtree, (Object)((SpatialEntry)node.getEntry(num)), num);
        if (++cur == depth) {
            return newSubtree;
        }
        if (childNode.isLeaf()) {
            assert (cur == newSubtree.getPathCount());
            throw new IllegalArgumentException("childNode is leaf, but currentDepth != depth: " + cur + " != " + depth);
        }
        return this.choosePath(newSubtree, mbr, depth, cur);
    }

    private N overflowTreatment(N node, IndexTreePath<E> path) {
        if (((RTreeSettings)this.settings).getOverflowTreatment().handleOverflow(this, node, path)) {
            return null;
        }
        return this.split(node);
    }

    private N split(N node) {
        int minimum = node.isLeaf() ? this.leafMinimum : this.dirMinimum;
        long[] split = ((RTreeSettings)this.settings).nodeSplitter.split(node, NodeArrayAdapter.STATIC, minimum);
        AbstractRStarTreeNode newNode = node.isLeaf() ? (AbstractRStarTreeNode)this.createNewLeafNode() : (AbstractRStarTreeNode)this.createNewDirectoryNode();
        node.splitByMask((AbstractNode)newNode, split);
        this.writeNode((Node)node);
        this.writeNode(newNode);
        return (N)((Object)newNode);
    }

    public void reInsert(N node, IndexTreePath<E> path, int[] offs) {
        int indexOfChild;
        AbstractRStarTreeNode parent;
        int depth = path.getPathCount();
        long[] remove = BitsUtil.zero((int)node.getCapacity());
        ArrayList<SpatialEntry> reInsertEntries = new ArrayList<SpatialEntry>(offs.length);
        for (int i = 0; i < offs.length; ++i) {
            reInsertEntries.add((SpatialEntry)node.getEntry(offs[i]));
            BitsUtil.setI((long[])remove, (int)offs[i]);
        }
        node.removeMask(remove);
        this.writeNode((Node)node);
        IndexTreePath childPath = path;
        Object child = node;
        while (childPath.getParentPath() != null && ((AbstractRStarTreeNode)((Object)child)).adjustEntry((SpatialEntry)((SpatialEntry)(parent = (AbstractRStarTreeNode)this.getNode((SpatialEntry)childPath.getParentPath().getEntry())).getEntry(indexOfChild = childPath.getIndex())))) {
            this.writeNode(parent);
            childPath = childPath.getParentPath();
            child = parent;
        }
        Logging log = this.getLogger();
        int oldheight = this.height;
        for (SpatialEntry entry : reInsertEntries) {
            if (log.isDebugging()) {
                log.debug((CharSequence)("reinsert " + entry + " at " + (depth + this.height - oldheight)));
            }
            this.insertEntry(entry, depth + this.height - oldheight);
        }
    }

    protected void adjustTree(IndexTreePath<E> subtree) {
        AbstractRStarTreeNode node;
        Logging log = this.getLogger();
        if (log.isDebugging()) {
            log.debugFine((CharSequence)("Adjust tree " + subtree));
        }
        if (this.hasOverflow(node = (AbstractRStarTreeNode)this.getNode((SpatialEntry)subtree.getEntry()))) {
            AbstractRStarTreeNode split = this.overflowTreatment(node, subtree);
            if (split != null) {
                if (this.isRoot(node)) {
                    IndexTreePath<E> newRootPath = this.createNewRoot(node, split);
                    ++this.height;
                    this.adjustTree(newRootPath);
                } else {
                    AbstractRStarTreeNode parent = (AbstractRStarTreeNode)this.getNode((SpatialEntry)subtree.getParentPath().getEntry());
                    if (log.isDebugging()) {
                        log.debugFine((CharSequence)("parent " + (Object)((Object)parent)));
                    }
                    parent.addEntry(this.createNewDirectoryEntry(split));
                    node.adjustEntry((SpatialEntry)parent.getEntry(subtree.getIndex()));
                    this.writeNode(parent);
                    this.adjustTree(subtree.getParentPath());
                }
            }
        } else if (!this.isRoot(node)) {
            AbstractRStarTreeNode parent = (AbstractRStarTreeNode)this.getNode((SpatialEntry)subtree.getParentPath().getEntry());
            SpatialEntry entry = (SpatialEntry)parent.getEntry(subtree.getIndex());
            boolean changed = node.adjustEntryIncremental(entry, (SpatialComparable)this.lastInsertedEntry);
            if (changed) {
                this.writeNode(parent);
                this.adjustTree(subtree.getParentPath());
            }
        } else {
            node.adjustEntry((SpatialEntry)this.getRootEntry());
        }
    }

    private void condenseTree(IndexTreePath<E> subtree, ArrayDeque<N> stack) {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.getNode((SpatialEntry)subtree.getEntry());
        if (!this.isRoot(node)) {
            AbstractRStarTreeNode parent = (AbstractRStarTreeNode)this.getNode((SpatialEntry)subtree.getParentPath().getEntry());
            int index = subtree.getIndex();
            if (this.hasUnderflow(node)) {
                if (parent.deleteEntry(index)) {
                    stack.push((N)((Object)node));
                } else {
                    node.adjustEntry((SpatialEntry)parent.getEntry(index));
                }
            } else {
                node.adjustEntry((SpatialEntry)parent.getEntry(index));
            }
            this.writeNode(parent);
            this.condenseTree(subtree.getParentPath(), stack);
        } else if (this.hasUnderflow(node) && node.getNumEntries() == 1 && !node.isLeaf()) {
            AbstractRStarTreeNode child = (AbstractRStarTreeNode)this.getNode((SpatialEntry)node.getEntry(0));
            AbstractRStarTreeNode newRoot = child.isLeaf() ? (AbstractRStarTreeNode)this.createNewLeafNode() : (AbstractRStarTreeNode)this.createNewDirectoryNode();
            newRoot.setPageID(this.getRootID());
            for (int i = 0; i < child.getNumEntries(); ++i) {
                newRoot.addEntry((SpatialEntry)child.getEntry(i));
            }
            this.writeNode(newRoot);
            --this.height;
        }
    }

    public final List<E> getLeaves() {
        ArrayList<SpatialEntry> result = new ArrayList<SpatialEntry>();
        if (this.height == 1) {
            result.add((SpatialEntry)this.getRootEntry());
            return result;
        }
        this.getLeafNodeEntries((AbstractRStarTreeNode)this.getNode(this.getRootID()), result, this.height);
        return result;
    }

    private void getLeafNodeEntries(N node, List<E> result, int currentLevel) {
        if (currentLevel == 2) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                result.add((SpatialEntry)node.getEntry(i));
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                this.getLeafNodeEntries((AbstractRStarTreeNode)this.getNode((SpatialEntry)node.getEntry(i)), result, currentLevel - 1);
            }
        }
    }

    public void doExtraIntegrityChecks() {
    }

    public void logStatistics() {
        Logging log = this.getLogger();
        if (log.isStatistics()) {
            super.logStatistics();
            log.statistics((Statistic)new LongStatistic(((Object)((Object)this)).getClass().getName() + ".height", (long)this.height));
            this.statistics.logStatistics();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(1000);
        if (!this.initialized) {
            return result.append(((Object)((Object)this)).getClass().getName()).append(" is not initialized.").toString();
        }
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.getNode(this.getRootID());
        int dim = ((SpatialEntry)this.getRootEntry()).getDimensionality();
        int dirNodes = 0;
        int leafNodes = 0;
        int objects = 0;
        int levels = 0;
        while (!node.isLeaf()) {
            if (node.getNumEntries() <= 0) continue;
            node = (AbstractRStarTreeNode)this.getNode((SpatialEntry)node.getEntry(0));
            ++levels;
        }
        BreadthFirstEnumeration enumeration = new BreadthFirstEnumeration((IndexTree)this, this.getRootPath());
        while (enumeration.hasNext()) {
            SpatialEntry entry = (SpatialEntry)enumeration.next().getEntry();
            if (entry instanceof LeafEntry) {
                ++objects;
                continue;
            }
            node = (AbstractRStarTreeNode)this.getNode(entry);
            if (node.isLeaf()) {
                ++leafNodes;
                continue;
            }
            ++dirNodes;
        }
        return result.append(((Object)((Object)this)).getClass().getName()).append(" has ").append(levels + 1).append(" levels.\n").append(dirNodes).append(" directory node (max = ").append(this.dirCapacity).append(", min = ").append(this.dirMinimum).append(")\n").append(leafNodes).append(" leaf node (max = ").append(this.leafCapacity).append(", min = ").append(this.leafMinimum).append(")\n").append(objects).append(' ').append(dim).append("-dim. objects").toString();
    }

    public class Statistics {
        protected final Counter distanceCalcs;
        protected final Counter knnQueries;
        protected final Counter rangeQueries;

        public Statistics() {
            Logging log = AbstractRStarTree.this.getLogger();
            String prefix = ((Object)((Object)AbstractRStarTree.this)).getClass().getName();
            this.distanceCalcs = log.isStatistics() ? log.newCounter(prefix + ".distancecalcs") : null;
            this.knnQueries = log.isStatistics() ? log.newCounter(prefix + ".knnqueries") : null;
            this.rangeQueries = log.isStatistics() ? log.newCounter(prefix + ".rangequeries") : null;
        }

        public void countDistanceCalculation() {
            if (this.distanceCalcs != null) {
                this.distanceCalcs.increment();
            }
        }

        public void countKNNQuery() {
            if (this.knnQueries != null) {
                this.knnQueries.increment();
            }
        }

        public void countRangeQuery() {
            if (this.rangeQueries != null) {
                this.rangeQueries.increment();
            }
        }

        public void logStatistics() {
            Logging log = AbstractRStarTree.this.getLogger();
            if (AbstractRStarTree.this.statistics.distanceCalcs != null) {
                log.statistics((Statistic)AbstractRStarTree.this.statistics.distanceCalcs);
            }
            if (AbstractRStarTree.this.statistics.knnQueries != null) {
                log.statistics((Statistic)AbstractRStarTree.this.statistics.knnQueries);
            }
            if (AbstractRStarTree.this.statistics.rangeQueries != null) {
                log.statistics((Statistic)AbstractRStarTree.this.statistics.rangeQueries);
            }
        }
    }
}

