/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.index.PagedIndexFactory;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.index.tree.spatial.rstarvariants.RTreeSettings;
import elki.index.tree.spatial.rstarvariants.strategies.bulk.BulkSplit;
import elki.index.tree.spatial.rstarvariants.strategies.insert.CombinedInsertionStrategy;
import elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import elki.index.tree.spatial.rstarvariants.strategies.overflow.LimitedReinsertOverflowTreatment;
import elki.index.tree.spatial.rstarvariants.strategies.overflow.OverflowTreatment;
import elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import elki.index.tree.spatial.rstarvariants.strategies.split.TopologicalSplitter;
import elki.persistent.PageFileFactory;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractRStarTreeFactory<O extends NumberVector, N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry, S extends RTreeSettings>
extends PagedIndexFactory<O> {
    protected S settings;

    public AbstractRStarTreeFactory(PageFileFactory<?> pageFileFactory, S settings) {
        super(pageFileFactory);
        this.settings = settings;
    }

    public TypeInformation getInputTypeRestriction() {
        return NumberVector.FIELD;
    }

    public static abstract class Par<O extends NumberVector, S extends RTreeSettings>
    extends PagedIndexFactory.Par<O> {
        public static final OptionID INSERTION_STRATEGY_ID = new OptionID("rtree.insertionstrategy", "The strategy to use for object insertion.");
        public static final OptionID SPLIT_STRATEGY_ID = new OptionID("rtree.splitstrategy", "The strategy to use for node splitting.");
        public static final OptionID BULK_SPLIT_ID = new OptionID("spatial.bulkstrategy", "The class to perform the bulk split with.");
        public static final OptionID MINIMUM_FILL_ID = new OptionID("rtree.minimum-fill", "Minimum relative fill required for data pages.");
        public static final OptionID OVERFLOW_STRATEGY_ID = new OptionID("rtree.overflowtreatment", "The strategy to use for handling overflows.");
        protected S settings;

        protected abstract S createSettings();

        public void configure(Parameterization config) {
            super.configure(config);
            this.settings = this.createSettings();
            new ObjectParameter(INSERTION_STRATEGY_ID, InsertionStrategy.class, CombinedInsertionStrategy.class).grab(config, x -> {
                ((RTreeSettings)this.settings).insertionStrategy = x;
            });
            new ObjectParameter(SPLIT_STRATEGY_ID, SplitStrategy.class, TopologicalSplitter.class).grab(config, x -> {
                ((RTreeSettings)this.settings).nodeSplitter = x;
            });
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(MINIMUM_FILL_ID, 0.4).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_HALF_DOUBLE)).grab(config, x -> {
                ((RTreeSettings)this.settings).relativeMinFill = x;
            });
            new ObjectParameter(OVERFLOW_STRATEGY_ID, OverflowTreatment.class, LimitedReinsertOverflowTreatment.class).grab(config, x -> ((RTreeSettings)this.settings).setOverflowTreatment((OverflowTreatment)x));
            this.configBulkLoad(config);
        }

        protected void configBulkLoad(Parameterization config) {
            new ObjectParameter(BULK_SPLIT_ID, BulkSplit.class).setOptional(true).grab(config, x -> {
                ((RTreeSettings)this.settings).bulkSplitter = x;
            });
        }

        public abstract AbstractRStarTreeFactory<O, ?, ?, ?> make();
    }
}

