/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants;

import elki.data.HyperBoundingBox;
import elki.data.ModifiableHyperBoundingBox;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.index.tree.AbstractNode;
import elki.index.tree.Node;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractRStarTreeNode<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry>
extends AbstractNode<E>
implements Node<E> {
    public AbstractRStarTreeNode() {
    }

    public AbstractRStarTreeNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    public ModifiableHyperBoundingBox computeMBR() {
        SpatialEntry firstEntry = (SpatialEntry)this.getEntry(0);
        if (firstEntry == null) {
            return null;
        }
        ModifiableHyperBoundingBox mbr = new ModifiableHyperBoundingBox((SpatialComparable)firstEntry);
        for (int i = 1; i < this.numEntries; ++i) {
            mbr.extend((SpatialComparable)this.getEntry(i));
        }
        return mbr;
    }

    public boolean adjustEntry(E entry) {
        SpatialDirectoryEntry se = (SpatialDirectoryEntry)entry;
        ModifiableHyperBoundingBox mbr = this.computeMBR();
        boolean changed = false;
        if (se.hasMBR()) {
            int dim = se.getDimensionality();
            for (int i = 0; i < dim; ++i) {
                if (Math.abs(se.getMin(i) - mbr.getMin(i)) > 1.1754943508222875E-38) {
                    changed = true;
                } else {
                    if (!(Math.abs(se.getMax(i) - mbr.getMax(i)) > 1.1754943508222875E-38)) continue;
                    changed = true;
                }
                break;
            }
        } else {
            changed = true;
        }
        if (changed) {
            se.setMBR(mbr);
        }
        return changed;
    }

    public boolean adjustEntryIncremental(E entry, SpatialComparable responsibleMBR) {
        return ((SpatialDirectoryEntry)entry).extendMBR(responsibleMBR);
    }

    public final int integrityCheck(AbstractRStarTree<N, E, ?> tree) {
        if (this.isLeaf()) {
            for (int i = 0; i < this.getCapacity(); ++i) {
                SpatialEntry e = (SpatialEntry)this.getEntry(i);
                if (i < this.getNumEntries() && e == null) {
                    throw new IllegalStateException("i < numEntries && entry == null");
                }
                if (i < this.getNumEntries() || e == null) continue;
                throw new IllegalStateException("i >= numEntries && entry != null");
            }
            return 0;
        }
        AbstractRStarTreeNode tmp = (AbstractRStarTreeNode)tree.getNode((SpatialEntry)this.getEntry(0));
        boolean childIsLeaf = tmp.isLeaf();
        int below = -1;
        for (int i = 0; i < this.getCapacity(); ++i) {
            SpatialEntry e = (SpatialEntry)this.getEntry(i);
            if (i < this.getNumEntries() && e == null) {
                throw new IllegalStateException("i < numEntries && entry == null");
            }
            if (i >= this.getNumEntries() && e != null) {
                throw new IllegalStateException("i >= numEntries && entry != null");
            }
            if (e == null) continue;
            AbstractRStarTreeNode node = (AbstractRStarTreeNode)tree.getNode(e);
            if (childIsLeaf && !node.isLeaf()) {
                for (int k = 0; k < this.getNumEntries(); ++k) {
                    tree.getNode((SpatialEntry)this.getEntry(k));
                }
                throw new IllegalStateException("Wrong Child in " + (Object)((Object)this) + " at " + i);
            }
            if (!childIsLeaf && node.isLeaf()) {
                throw new IllegalStateException("Wrong Child: child id no leaf, but node is leaf!");
            }
            node.integrityCheckParameters(this, i);
            int b = node.integrityCheck(tree);
            if (below >= 0 && b != below) {
                throw new IllegalStateException("Tree is not balanced.");
            }
            below = b;
        }
        return below + 1;
    }

    protected void integrityCheckParameters(N parent, int index) {
        SpatialEntry entry = (SpatialEntry)parent.getEntry(index);
        ModifiableHyperBoundingBox mbr = this.computeMBR();
        if (mbr == null) {
            return;
        }
        if (!SpatialUtil.equals((SpatialComparable)entry, (SpatialComparable)mbr)) {
            throw new IllegalStateException("Wrong MBR in node " + parent.getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + mbr.toString() + ",\n ist: " + new HyperBoundingBox((SpatialComparable)entry).toString());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.entries.length);
        for (Object entry : this.entries) {
            if (entry == null) break;
            ((SpatialEntry)entry).writeExternal(out);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int capacity = in.readInt();
        if (this.isLeaf()) {
            this.entries = new SpatialPointLeafEntry[capacity];
            for (int i = 0; i < this.numEntries; ++i) {
                SpatialPointLeafEntry s = new SpatialPointLeafEntry();
                s.readExternal(in);
                this.entries[i] = s;
            }
        } else {
            this.entries = new SpatialDirectoryEntry[capacity];
            for (int i = 0; i < this.numEntries; ++i) {
                SpatialDirectoryEntry s = new SpatialDirectoryEntry();
                s.readExternal(in);
                this.entries[i] = s;
            }
        }
    }
}

