/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants;

import elki.index.tree.Node;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.index.tree.spatial.rstarvariants.RTreeSettings;
import elki.persistent.PageFile;
import java.util.ArrayList;
import java.util.List;

public abstract class NonFlatRStarTree<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry, S extends RTreeSettings>
extends AbstractRStarTree<N, E, S> {
    public NonFlatRStarTree(PageFile<N> pagefile, S settings) {
        super(pagefile, settings);
    }

    @Override
    protected boolean hasOverflow(N node) {
        return node.getNumEntries() == (node.isLeaf() ? this.leafCapacity : this.dirCapacity);
    }

    @Override
    protected boolean hasUnderflow(N node) {
        return node.getNumEntries() < (node.isLeaf() ? this.leafMinimum : this.dirMinimum);
    }

    @Override
    protected int computeHeight() {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.getNode(this.getRootID());
        int height = 1;
        while (!node.isLeaf() && node.getNumEntries() != 0) {
            node = (AbstractRStarTreeNode)this.getNode((SpatialEntry)node.getEntry(0));
            ++height;
        }
        return height;
    }

    protected void createEmptyRoot(E exampleLeaf) {
        this.writeNode((AbstractRStarTreeNode)this.createNewLeafNode());
        this.setHeight(1);
    }

    @Override
    protected void bulkLoad(List<E> spatialObjects) {
        StringBuilder msg;
        if (!this.initialized) {
            this.initialize((SpatialEntry)spatialObjects.get(0));
        }
        StringBuilder stringBuilder = msg = this.getLogger().isDebuggingFine() ? new StringBuilder(500) : null;
        if (spatialObjects.size() <= this.leafCapacity) {
            AbstractRStarTreeNode root = (AbstractRStarTreeNode)this.createNewLeafNode();
            root.setPageID(this.getRootID());
            this.writeNode(root);
            this.createRoot(root, spatialObjects);
            this.setHeight(1);
            if (msg != null) {
                msg.append("\n  numNodes = 1");
            }
        } else {
            AbstractRStarTreeNode root = (AbstractRStarTreeNode)this.createNewDirectoryNode();
            root.setPageID(this.getRootID());
            this.writeNode(root);
            List<E> nodes = this.createBulkLeafNodes(spatialObjects);
            int numNodes = nodes.size();
            if (msg != null) {
                msg.append("\n  numLeafNodes = ").append(numNodes);
            }
            this.setHeight(1);
            while (nodes.size() > this.dirCapacity - 1) {
                nodes = this.createBulkDirectoryNodes(nodes);
                numNodes += nodes.size();
                this.setHeight(this.getHeight() + 1);
            }
            this.createRoot(root, nodes);
            ++numNodes;
            this.setHeight(this.getHeight() + 1);
            if (msg != null) {
                msg.append("\n  numNodes = ").append(numNodes);
            }
        }
        if (msg != null) {
            this.getLogger().debugFine((CharSequence)msg.append("\n  height = ").append(this.getHeight()).append("\n  root ").append(this.getNode(this.getRootID())).toString());
        }
    }

    private List<E> createBulkDirectoryNodes(List<E> nodes) {
        int minEntries = this.dirMinimum;
        int maxEntries = this.dirCapacity - 1;
        ArrayList result = new ArrayList();
        for (List<E> partition : this.settings.bulkSplitter.partition(nodes, minEntries, maxEntries)) {
            AbstractRStarTreeNode dirNode = (AbstractRStarTreeNode)this.createNewDirectoryNode();
            for (SpatialEntry o : partition) {
                dirNode.addEntry(o);
            }
            this.writeNode(dirNode);
            result.add(this.createNewDirectoryEntry(dirNode));
            if (!this.getLogger().isDebuggingFiner()) continue;
            this.getLogger().debugFiner((CharSequence)("Directory page no: " + dirNode.getPageID()));
        }
        return result;
    }

    private N createRoot(N root, List<E> objects) {
        for (SpatialEntry entry : objects) {
            root.addEntry((Object)entry);
        }
        ((SpatialDirectoryEntry)this.getRootEntry()).setMBR(((AbstractRStarTreeNode)((Object)root)).computeMBR());
        this.writeNode((Node)root);
        if (this.getLogger().isDebuggingFiner()) {
            this.getLogger().debugFiner((CharSequence)("pageNo " + root.getPageID()));
        }
        return root;
    }
}

