/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.deliclu;

import elki.index.tree.spatial.rstarvariants.NonFlatRStarTree;
import elki.index.tree.spatial.rstarvariants.RTreeSettings;
import elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluDirectoryEntry;
import elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluEntry;
import elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluNode;
import elki.logging.Logging;
import elki.persistent.PageFile;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;

public abstract class DeLiCluTree
extends NonFlatRStarTree<DeLiCluNode, DeLiCluEntry, RTreeSettings> {
    private static final Logging LOG = Logging.getLogger(DeLiCluTree.class);
    private Int2ObjectOpenHashMap<IntSet> expanded = new Int2ObjectOpenHashMap();

    public DeLiCluTree(PageFile<DeLiCluNode> pagefile, RTreeSettings settings) {
        super(pagefile, settings);
    }

    public void setExpanded(DeLiCluEntry entry1, DeLiCluEntry entry2) {
        IntSet exp1 = (IntSet)this.expanded.get(this.getPageID(entry1));
        if (exp1 == null) {
            exp1 = new IntOpenHashSet();
            this.expanded.put(this.getPageID(entry1), (Object)exp1);
        }
        exp1.add(this.getPageID(entry2));
    }

    public IntSet getExpanded(DeLiCluEntry entry) {
        IntSet exp = (IntSet)this.expanded.get(this.getPageID(entry));
        return exp != null ? exp : IntSets.EMPTY_SET;
    }

    public IntSet getExpanded(DeLiCluNode entry) {
        IntSet exp = (IntSet)this.expanded.get(entry.getPageID());
        return exp != null ? exp : IntSets.EMPTY_SET;
    }

    protected DeLiCluNode createNewLeafNode() {
        return new DeLiCluNode(this.leafCapacity, true);
    }

    protected DeLiCluNode createNewDirectoryNode() {
        return new DeLiCluNode(this.dirCapacity, false);
    }

    @Override
    protected DeLiCluEntry createNewDirectoryEntry(DeLiCluNode node) {
        return new DeLiCluDirectoryEntry(node.getPageID(), node.computeMBR(), node.hasHandled(), node.hasUnhandled());
    }

    protected DeLiCluEntry createRootEntry() {
        return new DeLiCluDirectoryEntry(0, null, false, true);
    }

    protected Logging getLogger() {
        return LOG;
    }
}

