/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.deliclu;

import elki.data.NumberVector;
import elki.data.spatial.SpatialComparable;
import elki.database.ids.DBID;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.PrioritySearcher;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.distance.SpatialDistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.index.DistancePriorityIndex;
import elki.index.DynamicIndex;
import elki.index.tree.IndexTreePath;
import elki.index.tree.spatial.rstarvariants.RTreeSettings;
import elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluEntry;
import elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluLeafEntry;
import elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluNode;
import elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluTree;
import elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import elki.logging.Logging;
import elki.persistent.PageFile;
import elki.utilities.exceptions.AbortException;
import java.util.ArrayList;

public class DeLiCluTreeIndex<O extends NumberVector>
extends DeLiCluTree
implements DistancePriorityIndex<O>,
DynamicIndex {
    private Relation<O> relation;
    private static final Logging LOG = Logging.getLogger(DeLiCluTreeIndex.class);

    public DeLiCluTreeIndex(Relation<O> relation, PageFile<DeLiCluNode> pagefile, RTreeSettings settings) {
        super(pagefile, settings);
        this.relation = relation;
    }

    protected DeLiCluLeafEntry createNewLeafEntry(DBID id) {
        return new DeLiCluLeafEntry(id, (NumberVector)this.relation.get((DBIDRef)id));
    }

    public synchronized IndexTreePath<DeLiCluEntry> setHandled(DBIDRef id, O obj) {
        IndexTreePath pathToObject;
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("setHandled " + DBIDUtil.toString((DBIDRef)id) + ", " + obj + "\n"));
        }
        if ((pathToObject = this.findPathToObject(this.getRootPath(), (SpatialComparable)obj, id)) == null) {
            throw new AbortException("Object not found in setHandled.");
        }
        DeLiCluEntry entry = (DeLiCluEntry)pathToObject.getEntry();
        entry.setHasHandled(true);
        entry.setHasUnhandled(false);
        IndexTreePath path = pathToObject;
        while (path.getParentPath() != null) {
            DeLiCluEntry parentEntry = (DeLiCluEntry)path.getParentPath().getEntry();
            DeLiCluNode node = (DeLiCluNode)this.getNode(parentEntry);
            boolean hasHandled = false;
            boolean hasUnhandled = false;
            for (int i = 0; i < node.getNumEntries(); ++i) {
                DeLiCluEntry nodeEntry = (DeLiCluEntry)node.getEntry(i);
                hasHandled = hasHandled || nodeEntry.hasHandled();
                hasUnhandled = hasUnhandled || nodeEntry.hasUnhandled();
            }
            parentEntry.setHasUnhandled(hasUnhandled);
            parentEntry.setHasHandled(hasHandled);
            path = path.getParentPath();
        }
        return pathToObject;
    }

    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    public final void insert(DBIDRef id) {
        this.insertLeaf(this.createNewLeafEntry(DBIDUtil.deref((DBIDRef)id)));
    }

    public final void insertAll(DBIDs ids) {
        if (ids.isEmpty() || ids.size() == 1) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<DeLiCluLeafEntry> leafs = new ArrayList<DeLiCluLeafEntry>(ids.size());
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                leafs.add(this.createNewLeafEntry(DBIDUtil.deref((DBIDRef)iter)));
                iter.advance();
            }
            this.bulkLoad(leafs);
        } else {
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                this.insert((DBIDRef)iter);
                iter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    public final boolean delete(DBIDRef id) {
        NumberVector obj = (NumberVector)this.relation.get(id);
        IndexTreePath deletionPath = this.findPathToObject(this.getRootPath(), (SpatialComparable)obj, id);
        if (deletionPath == null) {
            return false;
        }
        this.deletePath(deletionPath);
        return true;
    }

    public void deleteAll(DBIDs ids) {
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.delete((DBIDRef)DBIDUtil.deref((DBIDRef)iter));
            iter.advance();
        }
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return distanceQuery.getRelation() == this.relation && distanceQuery instanceof SpatialDistanceQuery ? RStarTreeUtil.getKNNQuery(this, (SpatialDistanceQuery)distanceQuery, maxk, flags) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return distanceQuery.getRelation() == this.relation && distanceQuery instanceof SpatialDistanceQuery ? RStarTreeUtil.getRangeQuery(this, (SpatialDistanceQuery)distanceQuery, maxradius, flags) : null;
    }

    public PrioritySearcher<O> priorityByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return distanceQuery.getRelation() == this.relation && distanceQuery instanceof SpatialDistanceQuery ? RStarTreeUtil.getDistancePrioritySearcher(this, (SpatialDistanceQuery)distanceQuery, maxradius, flags) : null;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

