/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.flat;

import elki.data.ModifiableHyperBoundingBox;
import elki.index.tree.TreeIndexHeader;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.RTreeSettings;
import elki.index.tree.spatial.rstarvariants.flat.FlatRStarTreeNode;
import elki.logging.Logging;
import elki.persistent.PageFile;
import java.util.List;

public abstract class FlatRStarTree
extends AbstractRStarTree<FlatRStarTreeNode, SpatialEntry, RTreeSettings> {
    private static final Logging LOG = Logging.getLogger(FlatRStarTree.class);
    private FlatRStarTreeNode root;

    public FlatRStarTree(PageFile<FlatRStarTreeNode> pagefile, RTreeSettings settings) {
        super(pagefile, settings);
    }

    @Override
    public void initializeFromFile(TreeIndexHeader header, PageFile<FlatRStarTreeNode> file) {
        int nextPageID;
        super.initializeFromFile(header, file);
        this.dirCapacity = nextPageID = file.getNextPageID();
        this.root = this.createNewDirectoryNode();
        for (int i = 1; i < nextPageID; ++i) {
            this.root.addEntry(this.createNewDirectoryEntry(this.getNode(i)));
        }
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("root: " + (Object)((Object)this.root) + " with " + nextPageID + " leafNodes."));
        }
    }

    public FlatRStarTreeNode getNode(int nodeID) {
        return nodeID == this.getRootID() ? this.root : (FlatRStarTreeNode)super.getNode(nodeID);
    }

    @Override
    protected int computeHeight() {
        return 2;
    }

    @Override
    protected void bulkLoad(List<SpatialEntry> spatialObjects) {
        if (!this.initialized) {
            this.initialize(spatialObjects.get(0));
        }
        this.root = this.createNewDirectoryNode();
        this.root.setPageID(this.getRootID());
        this.writeNode(this.root);
        List<SpatialEntry> nodes = this.createBulkLeafNodes(spatialObjects);
        int numNodes = nodes.size();
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("  numLeafNodes = " + numNodes));
        }
        this.root.increaseEntries(nodes.size());
        for (SpatialEntry entry : nodes) {
            this.root.addEntry(entry);
        }
        ((SpatialDirectoryEntry)this.getRootEntry()).setMBR(this.root.computeMBR());
        this.writeNode(this.root);
        ++numNodes;
        this.setHeight(2);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine((CharSequence)("  root = " + (Object)((Object)this.root) + "\n  numNodes = " + numNodes + "\n  height = " + this.getHeight()));
        }
        this.doExtraIntegrityChecks();
    }

    protected void createEmptyRoot(SpatialEntry exampleLeaf) {
        this.root = this.createNewDirectoryNode();
        this.root.setPageID(this.getRootID());
        this.writeNode(this.root);
        FlatRStarTreeNode leaf = this.createNewLeafNode();
        this.writeNode(leaf);
        assert (leaf.getPageID() != this.root.getPageID()) : "Page numbering inconsistent!?!";
        ModifiableHyperBoundingBox mbr = new ModifiableHyperBoundingBox(new double[exampleLeaf.getDimensionality()], new double[exampleLeaf.getDimensionality()]);
        this.root.addEntry(new SpatialDirectoryEntry(leaf.getPageID(), mbr));
        this.writeNode(this.root);
        this.setHeight(2);
    }

    @Override
    protected boolean hasOverflow(FlatRStarTreeNode node) {
        if (node.isLeaf()) {
            return node.getNumEntries() == this.leafCapacity;
        }
        if (node.getNumEntries() == node.getCapacity()) {
            node.increaseEntries(node.getCapacity() + 1);
        }
        return false;
    }

    @Override
    protected boolean hasUnderflow(FlatRStarTreeNode node) {
        return node.isLeaf() && node.getNumEntries() < this.leafMinimum;
    }

    protected FlatRStarTreeNode createNewLeafNode() {
        return new FlatRStarTreeNode(this.leafCapacity, true);
    }

    protected FlatRStarTreeNode createNewDirectoryNode() {
        return new FlatRStarTreeNode(this.dirCapacity, false);
    }

    @Override
    protected SpatialEntry createNewDirectoryEntry(FlatRStarTreeNode node) {
        return new SpatialDirectoryEntry(node.getPageID(), node.computeMBR());
    }

    protected SpatialEntry createRootEntry() {
        return new SpatialDirectoryEntry(0, null);
    }

    protected Logging getLogger() {
        return LOG;
    }
}

