/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.query;

import elki.data.spatial.SpatialComparable;
import elki.database.query.PrioritySearcher;
import elki.database.relation.Relation;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.utilities.datastructures.heap.DoubleIntegerMinHeap;

public class EuclideanRStarTreeDistancePrioritySearcher<O extends SpatialComparable>
implements PrioritySearcher<O> {
    protected final AbstractRStarTree<?, ?, ?> tree;
    private static final SquaredEuclideanDistance SQUARED = SquaredEuclideanDistance.STATIC;
    protected Relation<? extends O> relation;
    O query;
    double threshold = Double.POSITIVE_INFINITY;
    DoubleIntegerMinHeap pq = new DoubleIntegerMinHeap();
    AbstractRStarTreeNode<?, ?> node;
    int childnr = 0;
    private double mindist;

    public EuclideanRStarTreeDistancePrioritySearcher(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation) {
        this.relation = relation;
        this.tree = tree;
    }

    public EuclideanRStarTreeDistancePrioritySearcher<O> search(O query) {
        this.query = query;
        this.threshold = Double.POSITIVE_INFINITY;
        this.pq.clear();
        double rootdist = SQUARED.minDist(query, (SpatialComparable)this.tree.getRootEntry());
        this.tree.statistics.countDistanceCalculation();
        this.pq.add(rootdist, this.tree.getRootID());
        this.advance();
        return this;
    }

    public EuclideanRStarTreeDistancePrioritySearcher<O> decreaseCutoff(double threshold) {
        threshold *= threshold;
        assert (threshold <= this.threshold);
        this.threshold = threshold;
        return this;
    }

    public boolean valid() {
        return this.node != null && this.childnr < this.node.getNumEntries();
    }

    public EuclideanRStarTreeDistancePrioritySearcher<O> advance() {
        if (this.node != null && ++this.childnr < this.node.getNumEntries()) {
            return this;
        }
        while (this.advanceQueue()) {
            if (this.node == null) continue;
            assert (this.childnr == 0 && this.childnr < this.node.getNumEntries());
            break;
        }
        return this;
    }

    protected boolean advanceQueue() {
        if (this.pq.isEmpty()) {
            return false;
        }
        this.mindist = this.pq.peekKey();
        if (this.mindist > this.threshold) {
            this.pq.clear();
            return false;
        }
        this.node = (AbstractRStarTreeNode)this.tree.getNode(this.pq.peekValue());
        this.pq.poll();
        if (this.node.isLeaf()) {
            this.childnr = 0;
            this.mindist = this.mindist < 0.0 ? -this.mindist : 0.0;
        } else {
            for (int i = 0; i < this.node.getNumEntries(); ++i) {
                SpatialDirectoryEntry entry = (SpatialDirectoryEntry)this.node.getEntry(i);
                double distance = SQUARED.minDist(this.query, (SpatialComparable)entry);
                this.tree.statistics.countDistanceCalculation();
                if (!(distance <= this.threshold)) continue;
                this.pq.add(distance, entry.getPageID());
            }
            this.node = null;
        }
        return true;
    }

    public double getLowerBound() {
        return this.mindist < 0.0 ? (this.mindist = Math.sqrt(this.mindist)) : this.mindist;
    }

    public double allLowerBound() {
        return this.mindist < 0.0 ? (this.mindist = Math.sqrt(this.mindist)) : this.mindist;
    }

    public double computeExactDistance() {
        assert (this.valid());
        this.tree.statistics.countDistanceCalculation();
        return Math.sqrt(SQUARED.minDist(this.query, (SpatialComparable)this.node.getEntry(this.childnr)));
    }

    public int internalGetIndex() {
        assert (this.valid());
        SpatialPointLeafEntry entry = (SpatialPointLeafEntry)this.node.getEntry(this.childnr);
        return entry.getDBID().internalGetIndex();
    }
}

