/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.query;

import elki.data.NumberVector;
import elki.data.spatial.SpatialComparable;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.relation.Relation;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.index.tree.spatial.rstarvariants.query.RStarTreeKNNSearcher;
import elki.utilities.datastructures.heap.DoubleIntegerMinHeap;
import elki.utilities.documentation.Reference;

@Reference(authors="G. R. Hjaltason, H. Samet", title="Ranking in spatial databases", booktitle="4th Symp. Advances in Spatial Databases (SSD'95)", url="https://doi.org/10.1007/3-540-60159-7_6", bibkey="DBLP:conf/ssd/HjaltasonS95")
public class EuclideanRStarTreeKNNQuery<O extends NumberVector>
extends RStarTreeKNNSearcher<O> {
    private static final SquaredEuclideanDistance SQUARED = SquaredEuclideanDistance.STATIC;

    public EuclideanRStarTreeKNNQuery(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation) {
        super(tree, relation, EuclideanDistance.STATIC);
    }

    @Override
    public KNNList getKNN(O obj, int k) {
        double mindist;
        if (k < 1) {
            throw new IllegalArgumentException("At least one neighbor has to be requested!");
        }
        this.tree.statistics.countKNNQuery();
        KNNHeap knnList = DBIDUtil.newHeap((int)k);
        DoubleIntegerMinHeap pq = new DoubleIntegerMinHeap(Math.min(knnList.getK() << 1, 21));
        double maxDist = this.expandNode(obj, knnList, pq, Double.MAX_VALUE, this.tree.getRootID());
        while (!pq.isEmpty() && !((mindist = pq.peekKey()) > maxDist)) {
            int nodeID = pq.peekValue();
            pq.poll();
            maxDist = this.expandNode(obj, knnList, pq, maxDist, nodeID);
        }
        return knnList.toKNNListSqrt();
    }

    private double expandNode(O object, KNNHeap knnList, DoubleIntegerMinHeap pq, double maxDist, int nodeID) {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.tree.getNode(nodeID);
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                SpatialPointLeafEntry entry = (SpatialPointLeafEntry)node.getEntry(i);
                double distance = SQUARED.minDist((SpatialComparable)entry, object);
                this.tree.statistics.countDistanceCalculation();
                maxDist = distance <= maxDist ? knnList.insert(distance, (DBIDRef)entry.getDBID()) : maxDist;
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                SpatialDirectoryEntry entry = (SpatialDirectoryEntry)node.getEntry(i);
                double distance = SQUARED.minDist((SpatialComparable)entry, object);
                this.tree.statistics.countDistanceCalculation();
                if (distance <= 0.0) {
                    this.expandNode(object, knnList, pq, maxDist, entry.getPageID());
                    continue;
                }
                if (!(distance <= maxDist)) continue;
                pq.add(distance, entry.getPageID());
            }
        }
        return maxDist;
    }
}

