/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.query;

import elki.data.NumberVector;
import elki.data.spatial.SpatialComparable;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.relation.Relation;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.index.tree.spatial.rstarvariants.query.RStarTreeRangeSearcher;
import elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="J. Kuan, P. Lewis", title="Fast k nearest neighbour search for R-tree family", booktitle="Proc. Int. Conf Information, Communications and Signal Processing, ICICS 1997", url="https://doi.org/10.1109/ICICS.1997.652114", bibkey="doi:10.1109/ICICS.1997.652114")
public class EuclideanRStarTreeRangeQuery<O extends NumberVector>
extends RStarTreeRangeSearcher<O> {
    private static final SquaredEuclideanDistance SQUARED = SquaredEuclideanDistance.STATIC;

    public EuclideanRStarTreeRangeQuery(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation) {
        super(tree, relation, EuclideanDistance.STATIC);
    }

    @Override
    public ModifiableDoubleDBIDList getRange(O object, double range, ModifiableDoubleDBIDList result) {
        SquaredEuclideanDistance squared = SQUARED;
        double sqepsilon = range * range;
        this.tree.statistics.countRangeQuery();
        int[] pq = new int[101];
        int ps = 0;
        pq[ps++] = this.tree.getRootID();
        while (ps > 0) {
            double distance;
            SpatialEntry entry;
            int i;
            int pqNode = pq[--ps];
            AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.tree.getNode(pqNode);
            int numEntries = node.getNumEntries();
            if (node.isLeaf()) {
                for (i = 0; i < numEntries; ++i) {
                    entry = (SpatialPointLeafEntry)node.getEntry(i);
                    distance = squared.minDist(object, (SpatialComparable)entry);
                    this.tree.statistics.countDistanceCalculation();
                    if (!(distance <= sqepsilon)) continue;
                    result.add(Math.sqrt(distance), (DBIDRef)((SpatialPointLeafEntry)entry).getDBID());
                }
                continue;
            }
            for (i = 0; i < numEntries; ++i) {
                entry = (SpatialDirectoryEntry)node.getEntry(i);
                distance = squared.minDist(object, (SpatialComparable)entry);
                if (!(distance <= sqepsilon)) continue;
                if (ps == pq.length) {
                    pq = Arrays.copyOf(pq, pq.length + (pq.length >>> 1));
                }
                pq[ps++] = ((SpatialDirectoryEntry)entry).getPageID();
            }
        }
        return result;
    }
}

