/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.query;

import elki.data.spatial.SpatialComparable;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.PrioritySearcher;
import elki.database.relation.Relation;
import elki.distance.SpatialPrimitiveDistance;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.utilities.datastructures.heap.DoubleIntegerMinHeap;

public class RStarTreeDistancePrioritySearcher<O extends SpatialComparable>
implements PrioritySearcher<O> {
    protected final AbstractRStarTree<?, ?, ?> tree;
    protected final SpatialPrimitiveDistance<? super O> distance;
    protected Relation<? extends O> relation;
    O query;
    double threshold = Double.POSITIVE_INFINITY;
    DoubleIntegerMinHeap pq = new DoubleIntegerMinHeap();
    AbstractRStarTreeNode<?, ?> node;
    int childnr = 0;
    private double mindist;

    public RStarTreeDistancePrioritySearcher(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation, SpatialPrimitiveDistance<? super O> distance) {
        this.relation = relation;
        this.tree = tree;
        this.distance = distance;
    }

    public KNNList getKNN(O obj, int k) {
        KNNHeap heap = DBIDUtil.newHeap((int)k);
        double threshold = Double.POSITIVE_INFINITY;
        RStarTreeDistancePrioritySearcher<O> iter = this.search(obj);
        while (iter.valid()) {
            double dist = iter.computeExactDistance();
            if (dist <= threshold) {
                threshold = heap.insert(dist, iter);
                iter.decreaseCutoff(threshold);
            }
            iter.advance();
        }
        return heap.toKNNList();
    }

    public ModifiableDoubleDBIDList getRange(O obj, double range, ModifiableDoubleDBIDList result) {
        PrioritySearcher iter = this.search(obj, range);
        while (iter.valid()) {
            double dist = iter.computeExactDistance();
            if (dist <= range) {
                result.add(dist, (DBIDRef)iter);
            }
            iter.advance();
        }
        return result;
    }

    public RStarTreeDistancePrioritySearcher<O> search(O query) {
        this.query = query;
        this.threshold = Double.POSITIVE_INFINITY;
        this.pq.clear();
        double rootdist = this.distance.minDist(query, (SpatialComparable)this.tree.getRootEntry());
        this.tree.statistics.countDistanceCalculation();
        this.pq.add(rootdist, this.tree.getRootID());
        this.advance();
        return this;
    }

    public RStarTreeDistancePrioritySearcher<O> decreaseCutoff(double threshold) {
        assert (threshold <= this.threshold);
        this.threshold = threshold;
        return this;
    }

    public boolean valid() {
        return this.node != null && this.childnr < this.node.getNumEntries();
    }

    public RStarTreeDistancePrioritySearcher<O> advance() {
        if (this.node != null && ++this.childnr < this.node.getNumEntries()) {
            return this;
        }
        while (this.advanceQueue()) {
            if (this.node == null) continue;
            assert (this.childnr == 0 && this.childnr < this.node.getNumEntries());
            break;
        }
        return this;
    }

    protected boolean advanceQueue() {
        if (this.pq.isEmpty()) {
            return false;
        }
        this.mindist = this.pq.peekKey();
        if (this.mindist > this.threshold) {
            this.pq.clear();
            return false;
        }
        this.node = (AbstractRStarTreeNode)this.tree.getNode(this.pq.peekValue());
        this.pq.poll();
        if (this.node.isLeaf()) {
            this.childnr = 0;
        } else {
            for (int i = 0; i < this.node.getNumEntries(); ++i) {
                SpatialDirectoryEntry entry = (SpatialDirectoryEntry)this.node.getEntry(i);
                double dist = this.distance.minDist(this.query, (SpatialComparable)entry);
                this.tree.statistics.countDistanceCalculation();
                if (!(dist <= this.threshold)) continue;
                this.pq.add(dist, entry.getPageID());
            }
            this.node = null;
        }
        return true;
    }

    public double getLowerBound() {
        return this.mindist;
    }

    public double allLowerBound() {
        return this.mindist;
    }

    public double computeExactDistance() {
        assert (this.valid());
        this.tree.statistics.countDistanceCalculation();
        return this.distance.minDist(this.query, (SpatialComparable)this.node.getEntry(this.childnr));
    }

    public int internalGetIndex() {
        assert (this.valid());
        SpatialPointLeafEntry entry = (SpatialPointLeafEntry)this.node.getEntry(this.childnr);
        return entry.getDBID().internalGetIndex();
    }
}

