/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.query;

import elki.data.spatial.SpatialComparable;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.SpatialPrimitiveDistance;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.utilities.datastructures.heap.DoubleIntegerMinHeap;
import elki.utilities.documentation.Reference;

@Reference(authors="G. R. Hjaltason, H. Samet", title="Ranking in spatial databases", booktitle="4th Symp. Advances in Spatial Databases (SSD'95)", url="https://doi.org/10.1007/3-540-60159-7_6", bibkey="DBLP:conf/ssd/HjaltasonS95")
public class RStarTreeKNNSearcher<O extends SpatialComparable>
implements KNNSearcher<O> {
    protected final AbstractRStarTree<?, ?, ?> tree;
    protected final SpatialPrimitiveDistance<? super O> distance;
    protected Relation<? extends O> relation;

    public RStarTreeKNNSearcher(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation, SpatialPrimitiveDistance<? super O> distance) {
        this.relation = relation;
        this.tree = tree;
        this.distance = distance;
    }

    public KNNList getKNN(O obj, int k) {
        double mindist;
        if (k < 1) {
            throw new IllegalArgumentException("At least one neighbor has to be requested!");
        }
        this.tree.statistics.countKNNQuery();
        KNNHeap knnList = DBIDUtil.newHeap((int)k);
        DoubleIntegerMinHeap pq = new DoubleIntegerMinHeap(Math.min(knnList.getK() << 1, 21));
        double maxDist = this.expandNode(obj, knnList, pq, Double.MAX_VALUE, this.tree.getRootID());
        while (!pq.isEmpty() && !((mindist = pq.peekKey()) > maxDist)) {
            int nodeID = pq.peekValue();
            pq.poll();
            maxDist = this.expandNode(obj, knnList, pq, maxDist, nodeID);
        }
        return knnList.toKNNList();
    }

    private double expandNode(O object, KNNHeap knnList, DoubleIntegerMinHeap pq, double maxDist, int nodeID) {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.tree.getNode(nodeID);
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                SpatialPointLeafEntry entry = (SpatialPointLeafEntry)node.getEntry(i);
                double dist = this.distance.minDist((SpatialComparable)entry, object);
                this.tree.statistics.countDistanceCalculation();
                maxDist = dist <= maxDist ? knnList.insert(dist, (DBIDRef)entry.getDBID()) : maxDist;
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                SpatialDirectoryEntry entry = (SpatialDirectoryEntry)node.getEntry(i);
                double dist = this.distance.minDist((SpatialComparable)entry, object);
                this.tree.statistics.countDistanceCalculation();
                if (dist <= 0.0) {
                    this.expandNode(object, knnList, pq, maxDist, entry.getPageID());
                    continue;
                }
                if (!(dist <= maxDist)) continue;
                pq.add(dist, entry.getPageID());
            }
        }
        return maxDist;
    }
}

