/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.query;

import elki.data.spatial.SpatialComparable;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.distance.SpatialPrimitiveDistance;
import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="J. Kuan, P. Lewis", title="Fast k nearest neighbour search for R-tree family", booktitle="Proc. Int. Conf Information, Communications and Signal Processing, ICICS 1997", url="https://doi.org/10.1109/ICICS.1997.652114", bibkey="doi:10.1109/ICICS.1997.652114")
public class RStarTreeRangeSearcher<O extends SpatialComparable>
implements RangeSearcher<O> {
    protected final AbstractRStarTree<?, ?, ?> tree;
    protected final SpatialPrimitiveDistance<? super O> distance;
    protected Relation<? extends O> relation;

    public RStarTreeRangeSearcher(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation, SpatialPrimitiveDistance<? super O> distance) {
        this.relation = relation;
        this.tree = tree;
        this.distance = distance;
    }

    public ModifiableDoubleDBIDList getRange(O obj, double range, ModifiableDoubleDBIDList result) {
        this.tree.statistics.countRangeQuery();
        int[] pq = new int[101];
        int ps = 0;
        pq[ps++] = this.tree.getRootID();
        while (ps > 0) {
            double dist;
            SpatialEntry entry;
            int i;
            int pqNode = pq[--ps];
            AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.tree.getNode(pqNode);
            int numEntries = node.getNumEntries();
            if (node.isLeaf()) {
                for (i = 0; i < numEntries; ++i) {
                    entry = (SpatialPointLeafEntry)node.getEntry(i);
                    dist = this.distance.minDist(obj, (SpatialComparable)entry);
                    this.tree.statistics.countDistanceCalculation();
                    if (!(dist <= range)) continue;
                    result.add(dist, (DBIDRef)((SpatialPointLeafEntry)entry).getDBID());
                }
                continue;
            }
            for (i = 0; i < numEntries; ++i) {
                entry = (SpatialDirectoryEntry)node.getEntry(i);
                dist = this.distance.minDist(obj, (SpatialComparable)entry);
                this.tree.statistics.countDistanceCalculation();
                if (!(dist <= range)) continue;
                if (ps == pq.length) {
                    pq = Arrays.copyOf(pq, pq.length + (pq.length >>> 1));
                }
                pq[ps++] = ((SpatialDirectoryEntry)entry).getPageID();
            }
        }
        return result;
    }
}

