/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.query;

import elki.data.spatial.SpatialComparable;
import elki.database.query.PrioritySearcher;
import elki.database.query.distance.SpatialDistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.distance.SpatialPrimitiveDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.query.EuclideanRStarTreeDistancePrioritySearcher;
import elki.index.tree.spatial.rstarvariants.query.EuclideanRStarTreeKNNQuery;
import elki.index.tree.spatial.rstarvariants.query.EuclideanRStarTreeRangeQuery;
import elki.index.tree.spatial.rstarvariants.query.RStarTreeDistancePrioritySearcher;
import elki.index.tree.spatial.rstarvariants.query.RStarTreeKNNSearcher;
import elki.index.tree.spatial.rstarvariants.query.RStarTreeRangeSearcher;

public final class RStarTreeUtil {
    private RStarTreeUtil() {
    }

    public static <O extends SpatialComparable> RangeSearcher<O> getRangeQuery(AbstractRStarTree<?, ?, ?> tree, SpatialDistanceQuery<O> distanceQuery, Object ... hints) {
        SpatialPrimitiveDistance df = distanceQuery.getDistance();
        if (EuclideanDistance.STATIC.equals((Object)df)) {
            return new EuclideanRStarTreeRangeQuery(tree, distanceQuery.getRelation());
        }
        return new RStarTreeRangeSearcher(tree, distanceQuery.getRelation(), df);
    }

    public static <O extends SpatialComparable> KNNSearcher<O> getKNNQuery(AbstractRStarTree<?, ?, ?> tree, SpatialDistanceQuery<O> distanceQuery, Object ... hints) {
        SpatialPrimitiveDistance df = distanceQuery.getDistance();
        if (EuclideanDistance.STATIC.equals((Object)df)) {
            return new EuclideanRStarTreeKNNQuery(tree, distanceQuery.getRelation());
        }
        return new RStarTreeKNNSearcher(tree, distanceQuery.getRelation(), df);
    }

    public static <O extends SpatialComparable> PrioritySearcher<O> getDistancePrioritySearcher(AbstractRStarTree<?, ?, ?> tree, SpatialDistanceQuery<O> distanceQuery, Object ... hints) {
        SpatialPrimitiveDistance df = distanceQuery.getDistance();
        if (EuclideanDistance.STATIC.equals((Object)df)) {
            return new EuclideanRStarTreeDistancePrioritySearcher(tree, distanceQuery.getRelation());
        }
        return new RStarTreeDistancePrioritySearcher(tree, distanceQuery.getRelation(), df);
    }
}

