/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.rdknn;

import elki.data.NumberVector;
import elki.data.spatial.SpatialComparable;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBID;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.PrioritySearcher;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.distance.SpatialDistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.Relation;
import elki.distance.SpatialPrimitiveDistance;
import elki.index.DistancePriorityIndex;
import elki.index.DynamicIndex;
import elki.index.RKNNIndex;
import elki.index.tree.IndexTreePath;
import elki.index.tree.LeafEntry;
import elki.index.tree.TreeIndexHeader;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.index.tree.spatial.rstarvariants.NonFlatRStarTree;
import elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import elki.index.tree.spatial.rstarvariants.rdknn.RdKNNDirectoryEntry;
import elki.index.tree.spatial.rstarvariants.rdknn.RdKNNEntry;
import elki.index.tree.spatial.rstarvariants.rdknn.RdKNNLeafEntry;
import elki.index.tree.spatial.rstarvariants.rdknn.RdKNNNode;
import elki.index.tree.spatial.rstarvariants.rdknn.RdKNNTreeHeader;
import elki.index.tree.spatial.rstarvariants.rdknn.RdkNNSettings;
import elki.logging.Logging;
import elki.persistent.PageFile;
import elki.utilities.pairs.DoubleObjPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RdKNNTree<O extends NumberVector>
extends NonFlatRStarTree<RdKNNNode, RdKNNEntry, RdkNNSettings>
implements DistancePriorityIndex<O>,
RKNNIndex<O>,
DynamicIndex {
    private static final Logging LOG = Logging.getLogger(RdKNNTree.class);
    private SpatialDistanceQuery<O> distanceQuery;
    protected KNNSearcher<DBIDRef> knnQuery;
    private Relation<O> relation;

    public RdKNNTree(Relation<O> relation, PageFile<RdKNNNode> pagefile, RdkNNSettings settings) {
        super(pagefile, settings);
        this.relation = relation;
        this.distanceQuery = settings.distance.instantiate(relation);
        this.knnQuery = new QueryBuilder(this.distanceQuery).kNNByDBID();
    }

    protected void preInsert(RdKNNEntry entry) {
        KNNHeap knns_o = DBIDUtil.newHeap((int)((RdkNNSettings)this.settings).k_max);
        this.preInsert(entry, (RdKNNEntry)this.getRootEntry(), knns_o);
    }

    protected void postDelete(RdKNNEntry entry) {
        ModifiableDoubleDBIDList rnns = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNN((RdKNNNode)this.getNode(this.getRootID()), ((RdKNNLeafEntry)entry).getDBID(), rnns);
        ArrayModifiableDBIDs ids = DBIDUtil.newArray((DBIDs)rnns);
        ids.sort();
        double[] kdists = new double[ids.size()];
        DBIDArrayMIter iter = ids.iter();
        while (iter.valid()) {
            kdists[iter.getOffset()] = this.knnQuery.getKNN((Object)iter, ((RdkNNSettings)this.settings).k_max).getKNNDistance();
            iter.advance();
        }
        this.adjustKNNDistances((RdKNNEntry)this.getRootEntry(), (ArrayDBIDs)ids, kdists);
    }

    @Override
    protected void bulkLoad(List<RdKNNEntry> entries) {
        super.bulkLoad(entries);
        ArrayModifiableDBIDs ids = DBIDUtil.newArray((int)entries.size());
        for (RdKNNEntry entry : entries) {
            ids.add((DBIDRef)((RdKNNLeafEntry)entry).getDBID());
        }
        ids.sort();
        double[] kdists = new double[ids.size()];
        DBIDArrayMIter iter = ids.iter();
        while (iter.valid()) {
            kdists[iter.getOffset()] = this.knnQuery.getKNN((Object)iter, ((RdkNNSettings)this.settings).k_max).getKNNDistance();
            iter.advance();
        }
        this.adjustKNNDistances((RdKNNEntry)this.getRootEntry(), (ArrayDBIDs)ids, kdists);
        this.doExtraIntegrityChecks();
    }

    public DoubleDBIDList reverseKNNQuery(DBID oid, int k, SpatialPrimitiveDistance<? super O> distance) {
        this.checkDistance(distance);
        if (k > ((RdkNNSettings)this.settings).k_max) {
            throw new IllegalArgumentException("Parameter k is not supported, k > k_max: " + k + " > " + ((RdkNNSettings)this.settings).k_max);
        }
        ModifiableDoubleDBIDList candidates = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNN((RdKNNNode)this.getNode(this.getRootID()), oid, candidates);
        if (k == ((RdkNNSettings)this.settings).k_max) {
            return candidates.sort();
        }
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        DoubleDBIDListMIter iter = candidates.iter();
        while (iter.valid()) {
            DoubleDBIDListIter qr = this.knnQuery.getKNN((Object)iter, k).iter();
            while (qr.valid()) {
                if (DBIDUtil.equal((DBIDRef)oid, (DBIDRef)qr)) {
                    result.add(qr.doubleValue(), (DBIDRef)iter);
                    break;
                }
                qr.advance();
            }
            iter.advance();
        }
        return result.sort();
    }

    protected TreeIndexHeader createHeader() {
        return new RdKNNTreeHeader(this.getPageSize(), this.dirCapacity, this.leafCapacity, this.dirMinimum, this.leafCapacity, ((RdkNNSettings)this.settings).k_max);
    }

    @Override
    protected void initializeCapacities(RdKNNEntry exampleLeaf) {
        int dimensionality = exampleLeaf.getDimensionality();
        int distanceSize = 8;
        double overhead = 16.125;
        if ((double)this.getPageSize() - overhead < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)(((double)this.getPageSize() - overhead) / (double)(4 + 16 * dimensionality + distanceSize)) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1)));
        }
        this.dirMinimum = (int)Math.round((double)(this.dirCapacity - 1) * 0.5);
        if (this.dirMinimum < 2) {
            this.dirMinimum = 2;
        }
        this.leafCapacity = (int)(((double)this.getPageSize() - overhead) / (double)(4 + 8 * dimensionality + distanceSize)) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning((CharSequence)("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1)));
        }
        this.leafMinimum = (int)Math.round((double)(this.leafCapacity - 1) * 0.5);
        if (this.leafMinimum < 2) {
            this.leafMinimum = 2;
        }
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)("Directory Capacity: " + this.dirCapacity + "\nLeaf Capacity: " + this.leafCapacity));
        }
    }

    protected List<DoubleObjPair<RdKNNEntry>> getSortedEntries(AbstractRStarTreeNode<?, ?> node, SpatialComparable q, SpatialPrimitiveDistance<?> distance) {
        ArrayList<DoubleObjPair<RdKNNEntry>> result = new ArrayList<DoubleObjPair<RdKNNEntry>>();
        for (int i = 0; i < node.getNumEntries(); ++i) {
            RdKNNEntry entry = (RdKNNEntry)node.getEntry(i);
            double minDist = distance.minDist((SpatialComparable)entry, q);
            result.add((DoubleObjPair<RdKNNEntry>)new DoubleObjPair(minDist, (Object)entry));
        }
        Collections.sort(result);
        return result;
    }

    private void preInsert(RdKNNEntry q, RdKNNEntry nodeEntry, KNNHeap knns_q) {
        double knnDist_q = knns_q.getKNNDistance();
        RdKNNNode node = (RdKNNNode)this.getNode(nodeEntry);
        double knnDist_node = 0.0;
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNLeafEntry p = (RdKNNLeafEntry)node.getEntry(i);
                double dist_pq = this.distanceQuery.distance((DBIDRef)p.getDBID(), (DBIDRef)((LeafEntry)q).getDBID());
                if (dist_pq <= knnDist_q) {
                    knns_q.insert(dist_pq, (DBIDRef)p.getDBID());
                    if (knns_q.size() >= ((RdkNNSettings)this.settings).k_max) {
                        knnDist_q = knns_q.getKNNDistance();
                        q.setKnnDistance(knnDist_q);
                    }
                }
                if (dist_pq <= p.getKnnDistance()) {
                    KNNList knns_without_q = this.knnQuery.getKNN((Object)p.getDBID(), ((RdkNNSettings)this.settings).k_max);
                    p.setKnnDistance(knns_without_q.size() + 1 < ((RdkNNSettings)this.settings).k_max ? Double.NaN : Math.min(knns_without_q.doubleValue(knns_without_q.size() - 1), dist_pq));
                }
                knnDist_node = Math.max(knnDist_node, p.getKnnDistance());
            }
        } else {
            NumberVector obj = (NumberVector)this.relation.get((DBIDRef)((LeafEntry)q).getDBID());
            List<DoubleObjPair<RdKNNEntry>> entries = this.getSortedEntries(node, (SpatialComparable)obj, ((RdkNNSettings)this.settings).distance);
            for (DoubleObjPair<RdKNNEntry> distEntry : entries) {
                RdKNNEntry entry = (RdKNNEntry)distEntry.second;
                double entry_knnDist = entry.getKnnDistance();
                if (distEntry.first < entry_knnDist || distEntry.first < knnDist_q) {
                    this.preInsert(q, entry, knns_q);
                    knnDist_q = knns_q.getKNNDistance();
                }
                knnDist_node = Math.max(knnDist_node, entry.getKnnDistance());
            }
        }
        nodeEntry.setKnnDistance(knnDist_node);
    }

    private void doReverseKNN(RdKNNNode node, DBID oid, ModifiableDoubleDBIDList result) {
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNLeafEntry entry = (RdKNNLeafEntry)node.getEntry(i);
                double distance = this.distanceQuery.distance((DBIDRef)entry.getDBID(), (DBIDRef)oid);
                if (!(distance <= entry.getKnnDistance())) continue;
                result.add(distance, (DBIDRef)entry.getDBID());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNDirectoryEntry entry = (RdKNNDirectoryEntry)node.getEntry(i);
                double minDist = this.distanceQuery.minDist((SpatialComparable)entry, (DBIDRef)oid);
                if (!(minDist <= entry.getKnnDistance())) continue;
                this.doReverseKNN((RdKNNNode)this.getNode(entry), oid, result);
            }
        }
    }

    private void adjustKNNDistances(RdKNNEntry entry, ArrayDBIDs ids, double[] kdists) {
        RdKNNNode node = (RdKNNNode)this.getNode(entry);
        double knnDist_node = 0.0;
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNEntry leafEntry = (RdKNNEntry)node.getEntry(i);
                DBID id = ((LeafEntry)leafEntry).getDBID();
                int pos = ids.binarySearch((DBIDRef)id);
                if (pos >= 0) {
                    leafEntry.setKnnDistance(kdists[pos]);
                }
                knnDist_node = Math.max(knnDist_node, leafEntry.getKnnDistance());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNEntry dirEntry = (RdKNNEntry)node.getEntry(i);
                this.adjustKNNDistances(dirEntry, ids, kdists);
                knnDist_node = Math.max(knnDist_node, dirEntry.getKnnDistance());
            }
        }
        entry.setKnnDistance(knnDist_node);
    }

    protected RdKNNNode createNewLeafNode() {
        return new RdKNNNode(this.leafCapacity, true);
    }

    protected RdKNNNode createNewDirectoryNode() {
        return new RdKNNNode(this.dirCapacity, false);
    }

    @Override
    protected RdKNNEntry createNewDirectoryEntry(RdKNNNode node) {
        return new RdKNNDirectoryEntry(node.getPageID(), node.computeMBR(), node.kNNDistance());
    }

    protected RdKNNEntry createRootEntry() {
        return new RdKNNDirectoryEntry(0, null, Double.NaN);
    }

    private void checkDistance(SpatialPrimitiveDistance<? super O> distance) {
        if (!((RdkNNSettings)this.settings).distance.equals(distance)) {
            throw new IllegalArgumentException("Parameter distance must be an instance of " + this.distanceQuery.getClass() + ", but is " + distance.getClass());
        }
    }

    protected RdKNNLeafEntry createNewLeafEntry(DBID id) {
        return new RdKNNLeafEntry(id, (NumberVector)this.relation.get((DBIDRef)id), Double.NaN);
    }

    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    public final void insert(DBIDRef id) {
        this.insertLeaf(this.createNewLeafEntry(DBIDUtil.deref((DBIDRef)id)));
    }

    public final void insertAll(DBIDs ids) {
        if (ids.isEmpty() || ids.size() == 1) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<RdKNNEntry> leafs = new ArrayList<RdKNNEntry>(ids.size());
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                leafs.add(this.createNewLeafEntry(DBIDUtil.deref((DBIDRef)iter)));
                iter.advance();
            }
            this.bulkLoad((List<RdKNNEntry>)leafs);
        } else {
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                this.insert((DBIDRef)iter);
                iter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    public final boolean delete(DBIDRef id) {
        NumberVector obj = (NumberVector)this.relation.get(id);
        IndexTreePath deletionPath = this.findPathToObject(this.getRootPath(), (SpatialComparable)obj, id);
        if (deletionPath == null) {
            return false;
        }
        this.deletePath(deletionPath);
        return true;
    }

    public void deleteAll(DBIDs ids) {
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.delete((DBIDRef)DBIDUtil.deref((DBIDRef)iter));
            iter.advance();
        }
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return distanceQuery.getRelation() == this.relation && distanceQuery instanceof SpatialDistanceQuery ? RStarTreeUtil.getKNNQuery(this, (SpatialDistanceQuery)distanceQuery, maxk, flags) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return distanceQuery.getRelation() == this.relation && distanceQuery instanceof SpatialDistanceQuery ? RStarTreeUtil.getRangeQuery(this, (SpatialDistanceQuery)distanceQuery, maxradius, flags) : null;
    }

    public PrioritySearcher<O> priorityByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return distanceQuery.getRelation() == this.relation && distanceQuery instanceof SpatialDistanceQuery ? RStarTreeUtil.getDistancePrioritySearcher(this, (SpatialDistanceQuery)distanceQuery, maxradius, flags) : null;
    }

    public RKNNSearcher<O> rkNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    public RKNNSearcher<DBIDRef> rkNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return null;
    }

    protected Logging getLogger() {
        return LOG;
    }
}

