/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.rdknn;

import elki.data.NumberVector;
import elki.database.relation.Relation;
import elki.distance.SpatialPrimitiveDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeFactory;
import elki.index.tree.spatial.rstarvariants.rdknn.RdKNNEntry;
import elki.index.tree.spatial.rstarvariants.rdknn.RdKNNNode;
import elki.index.tree.spatial.rstarvariants.rdknn.RdKNNTree;
import elki.index.tree.spatial.rstarvariants.rdknn.RdkNNSettings;
import elki.persistent.PageFile;
import elki.persistent.PageFileFactory;
import elki.utilities.ClassGenericsUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class RdKNNTreeFactory<O extends NumberVector>
extends AbstractRStarTreeFactory<O, RdKNNNode, RdKNNEntry, RdkNNSettings> {
    public static final OptionID K_ID = new OptionID("rdknn.k", "positive integer specifying the maximal number k of reverse k nearest neighbors to be supported.");
    public static final Class<?> DEFAULT_DISTANCE_FUNCTION = EuclideanDistance.class;
    public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("rdknn.distancefunction", "Distance function to determine the distance between database objects.");

    public RdKNNTreeFactory(PageFileFactory<?> pageFileFactory, RdkNNSettings settings) {
        super(pageFileFactory, settings);
    }

    public RdKNNTree<O> instantiate(Relation<O> relation) {
        PageFile pagefile = this.makePageFile(this.getNodeClass());
        RdKNNTree<O> index = new RdKNNTree<O>(relation, (PageFile<RdKNNNode>)pagefile, (RdkNNSettings)this.settings);
        return index;
    }

    protected Class<RdKNNNode> getNodeClass() {
        return ClassGenericsUtil.uglyCastIntoSubclass(RdKNNNode.class);
    }

    public static class Par<O extends NumberVector>
    extends AbstractRStarTreeFactory.Par<O, RdkNNSettings> {
        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                ((RdkNNSettings)this.settings).k_max = x;
            });
            new ObjectParameter(DISTANCE_FUNCTION_ID, SpatialPrimitiveDistance.class, DEFAULT_DISTANCE_FUNCTION).grab(config, x -> {
                ((RdkNNSettings)this.settings).distance = x;
            });
        }

        @Override
        public RdKNNTreeFactory<O> make() {
            return new RdKNNTreeFactory(this.pageFileFactory, (RdkNNSettings)this.settings);
        }

        @Override
        protected RdkNNSettings createSettings() {
            return new RdkNNSettings(1, (SpatialPrimitiveDistance<NumberVector>)EuclideanDistance.STATIC);
        }
    }
}

