/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.rstar;

import elki.index.tree.spatial.SpatialDirectoryEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.rstarvariants.NonFlatRStarTree;
import elki.index.tree.spatial.rstarvariants.RTreeSettings;
import elki.index.tree.spatial.rstarvariants.rstar.RStarTreeNode;
import elki.logging.Logging;
import elki.persistent.PageFile;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="R*-Tree")
@Description(value="Balanced index structure based on bounding rectangles.")
@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public abstract class RStarTree
extends NonFlatRStarTree<RStarTreeNode, SpatialEntry, RTreeSettings> {
    private static final Logging LOG = Logging.getLogger(RStarTree.class);

    public RStarTree(PageFile<RStarTreeNode> pagefile, RTreeSettings settings) {
        super(pagefile, settings);
    }

    protected SpatialEntry createRootEntry() {
        return new SpatialDirectoryEntry(0, null);
    }

    @Override
    protected SpatialEntry createNewDirectoryEntry(RStarTreeNode node) {
        return new SpatialDirectoryEntry(node.getPageID(), node.computeMBR());
    }

    protected RStarTreeNode createNewLeafNode() {
        return new RStarTreeNode(this.leafCapacity, true);
    }

    protected RStarTreeNode createNewDirectoryNode() {
        return new RStarTreeNode(this.dirCapacity, false);
    }

    protected Logging getLogger() {
        return LOG;
    }
}

