/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.rstar;

import elki.data.NumberVector;
import elki.data.spatial.SpatialComparable;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.PrioritySearcher;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.distance.SpatialDistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.index.DistancePriorityIndex;
import elki.index.DynamicIndex;
import elki.index.tree.IndexTreePath;
import elki.index.tree.spatial.SpatialPointLeafEntry;
import elki.index.tree.spatial.rstarvariants.RTreeSettings;
import elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import elki.index.tree.spatial.rstarvariants.rstar.RStarTree;
import elki.index.tree.spatial.rstarvariants.rstar.RStarTreeNode;
import elki.logging.Logging;
import elki.persistent.PageFile;
import java.util.ArrayList;

public class RStarTreeIndex<O extends NumberVector>
extends RStarTree
implements DistancePriorityIndex<O>,
DynamicIndex {
    private static final Logging LOG = Logging.getLogger(RStarTreeIndex.class);
    private Relation<O> relation;

    public RStarTreeIndex(Relation<O> relation, PageFile<RStarTreeNode> pagefile, RTreeSettings settings) {
        super(pagefile, settings);
        this.relation = relation;
    }

    protected SpatialPointLeafEntry createNewLeafEntry(DBIDRef id) {
        return new SpatialPointLeafEntry(DBIDUtil.deref((DBIDRef)id), (NumberVector)this.relation.get(id));
    }

    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    public void insert(DBIDRef id) {
        this.insertLeaf(this.createNewLeafEntry(id));
    }

    public void insertAll(DBIDs ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<SpatialPointLeafEntry> leafs = new ArrayList<SpatialPointLeafEntry>(ids.size());
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                leafs.add(this.createNewLeafEntry((DBIDRef)iter));
                iter.advance();
            }
            this.bulkLoad(leafs);
        } else {
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                this.insert((DBIDRef)DBIDUtil.deref((DBIDRef)iter));
                iter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    public boolean delete(DBIDRef id) {
        NumberVector obj = (NumberVector)this.relation.get(id);
        IndexTreePath deletionPath = this.findPathToObject(this.getRootPath(), (SpatialComparable)obj, id);
        if (deletionPath == null) {
            return false;
        }
        this.deletePath(deletionPath);
        return true;
    }

    public void deleteAll(DBIDs ids) {
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.delete((DBIDRef)iter);
            iter.advance();
        }
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        return distanceQuery.getRelation() == this.relation && distanceQuery instanceof SpatialDistanceQuery ? RStarTreeUtil.getKNNQuery(this, (SpatialDistanceQuery)distanceQuery, maxk, flags) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return distanceQuery.getRelation() == this.relation && distanceQuery instanceof SpatialDistanceQuery ? RStarTreeUtil.getRangeQuery(this, (SpatialDistanceQuery)distanceQuery, maxradius, flags) : null;
    }

    public PrioritySearcher<O> priorityByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        return distanceQuery.getRelation() == this.relation && distanceQuery instanceof SpatialDistanceQuery ? RStarTreeUtil.getDistancePrioritySearcher(this, (SpatialDistanceQuery)distanceQuery, maxradius, flags) : null;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

