/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.bulk;

import elki.index.tree.spatial.rstarvariants.strategies.bulk.BulkSplit;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBulkSplit
implements BulkSplit {
    protected int chooseBulkSplitPoint(int numEntries, int minEntries, int maxEntries) {
        if (numEntries < minEntries) {
            throw new IllegalArgumentException("numEntries < minEntries!");
        }
        if (numEntries <= maxEntries) {
            return numEntries;
        }
        if (numEntries < maxEntries + minEntries) {
            return numEntries - minEntries;
        }
        return maxEntries;
    }

    protected <T> List<List<T>> trivialPartition(List<T> objects, int minEntries, int maxEntries) {
        int size = objects.size();
        int numberPartitions = (int)Math.ceil((double)size / (double)maxEntries);
        ArrayList<List<T>> partitions = new ArrayList<List<T>>(numberPartitions);
        int start = 0;
        for (int pnum = 0; pnum < numberPartitions; ++pnum) {
            int end = (int)(((double)pnum + 1.0) * (double)size / (double)numberPartitions);
            if (pnum == numberPartitions - 1) {
                end = size;
            }
            assert (end - start >= minEntries && end - start <= maxEntries);
            partitions.add(objects.subList(start, end));
            start = end;
        }
        return partitions;
    }
}

