/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.bulk;

import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialSingleMinComparator;
import elki.index.tree.spatial.rstarvariants.strategies.bulk.AbstractBulkSplit;
import elki.logging.Logging;
import elki.utilities.optionhandling.Parameterizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MaxExtensionBulkSplit
extends AbstractBulkSplit {
    private static final Logging LOG = Logging.getLogger(MaxExtensionBulkSplit.class);
    public static final MaxExtensionBulkSplit STATIC = new MaxExtensionBulkSplit();

    public <N extends SpatialComparable> List<List<N>> partition(List<N> spatialObjects, int minEntries, int maxEntries) {
        ArrayList<List<N>> partitions = new ArrayList<List<N>>();
        ArrayList<N> objects = new ArrayList<N>(spatialObjects);
        while (!objects.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            int splitAxis = this.chooseMaximalExtendedSplitAxis(objects);
            int splitPoint = this.chooseBulkSplitPoint(objects.size(), minEntries, maxEntries);
            if (LOG.isDebugging()) {
                msg.append("\nsplitAxis ").append(splitAxis);
                msg.append("\nsplitPoint ").append(splitPoint);
            }
            Collections.sort(objects, new SpatialSingleMinComparator(splitAxis));
            ArrayList<SpatialComparable> partition1 = new ArrayList<SpatialComparable>();
            for (int i = 0; i < splitPoint; ++i) {
                SpatialComparable o = (SpatialComparable)objects.remove(0);
                partition1.add(o);
            }
            partitions.add(partition1);
            if (!LOG.isDebugging()) continue;
            msg.append("\ncurrent partition ").append(partition1);
            msg.append("\nremaining objects # ").append(objects.size());
            LOG.debugFine((CharSequence)msg.toString());
        }
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)("partitions " + partitions));
        }
        return partitions;
    }

    private int chooseMaximalExtendedSplitAxis(List<? extends SpatialComparable> objects) {
        int dimension = objects.get(0).getDimensionality();
        double[] maxExtension = new double[dimension];
        double[] minExtension = new double[dimension];
        Arrays.fill(minExtension, Double.MAX_VALUE);
        for (SpatialComparable spatialComparable : objects) {
            for (int d = 0; d < dimension; ++d) {
                double min = spatialComparable.getMin(d);
                double max = spatialComparable.getMax(d);
                if (maxExtension[d] < max) {
                    maxExtension[d] = max;
                }
                if (!(minExtension[d] > min)) continue;
                minExtension[d] = min;
            }
        }
        int splitAxis = -1;
        double d = 0.0;
        for (int d2 = 0; d2 < dimension; ++d2) {
            double currentExtension = maxExtension[d2] - minExtension[d2];
            if (!(d < currentExtension)) continue;
            d = currentExtension;
            splitAxis = d2;
        }
        return splitAxis;
    }

    public static class Par
    implements Parameterizer {
        public MaxExtensionBulkSplit make() {
            return STATIC;
        }
    }
}

