/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.bulk;

import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialSingleMeanComparator;
import elki.index.tree.spatial.rstarvariants.strategies.bulk.AbstractBulkSplit;
import elki.utilities.Alias;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="S. T. Leutenegger, M. A. Lopez, J. Edgington", title="STR: A simple and efficient algorithm for R-tree packing", booktitle="Proc. 13th International Conference on Data Engineering (ICDE 1997)", url="https://doi.org/10.1109/ICDE.1997.582015", bibkey="DBLP:conf/icde/LeuteneggerEL97")
@Alias(value={"str", "STR"})
public class SortTileRecursiveBulkSplit
extends AbstractBulkSplit {
    public static final SortTileRecursiveBulkSplit STATIC = new SortTileRecursiveBulkSplit();

    @Override
    public <T extends SpatialComparable> List<List<T>> partition(List<T> spatialObjects, int minEntries, int maxEntries) {
        int dims = ((SpatialComparable)spatialObjects.get(0)).getDimensionality();
        int p = (int)FastMath.ceil((double)((double)spatialObjects.size() / (double)maxEntries));
        ArrayList<List<T>> ret = new ArrayList<List<T>>(p);
        this.strPartition(spatialObjects, 0, spatialObjects.size(), 0, dims, maxEntries, new SpatialSingleMeanComparator(0), ret);
        return ret;
    }

    protected <T extends SpatialComparable> void strPartition(List<T> objs, int start, int end, int depth, int dims, int maxEntries, SpatialSingleMeanComparator c, List<List<T>> ret) {
        int p = (int)FastMath.ceil((double)((double)(end - start) / (double)maxEntries));
        int s = (int)FastMath.ceil((double)FastMath.pow((double)p, (double)(1.0 / (double)(dims - depth))));
        double len = end - start;
        for (int i = 0; i < s; ++i) {
            int s2 = start + (int)((double)i * len / (double)s);
            int e2 = start + (int)((double)(i + 1) * len / (double)s);
            if (e2 < end) {
                c.setDimension(depth);
                QuickSelect.quickSelect(objs, (Comparator)c, (int)s2, (int)end, (int)e2);
            }
            if (depth + 1 == dims) {
                ret.add(objs.subList(s2, e2));
                continue;
            }
            this.strPartition(objs, s2, e2, depth + 1, dims, maxEntries, c, ret);
        }
    }

    public static class Par
    implements Parameterizer {
        public SortTileRecursiveBulkSplit make() {
            return STATIC;
        }
    }
}

