/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.bulk;

import elki.data.spatial.SpatialComparable;
import elki.index.tree.spatial.rstarvariants.strategies.bulk.AbstractBulkSplit;
import elki.math.spacefillingcurves.SpatialSorter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="I. Kamel, C. Faloutsos", title="On packing R-trees", booktitle="Proc. 2nd Int. Conf. on Information and Knowledge Management", url="https://doi.org/10.1145/170088.170403", bibkey="DBLP:conf/cikm/KamelF93")
public class SpatialSortBulkSplit
extends AbstractBulkSplit {
    final SpatialSorter sorter;

    protected SpatialSortBulkSplit(SpatialSorter sorter) {
        this.sorter = sorter;
    }

    @Override
    public <T extends SpatialComparable> List<List<T>> partition(List<T> spatialObjects, int minEntries, int maxEntries) {
        this.sorter.sort(spatialObjects);
        return super.trivialPartition(spatialObjects, minEntries, maxEntries);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID SORTER_ID = new OptionID("rtree.bulk.spatial-sort", "Strategy for spatial sorting in bulk loading.");
        SpatialSorter sorter;

        public void configure(Parameterization config) {
            new ObjectParameter(SORTER_ID, SpatialSorter.class).grab(config, x -> {
                this.sorter = x;
            });
        }

        public SpatialSortBulkSplit make() {
            return new SpatialSortBulkSplit(this.sorter);
        }
    }
}

