/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.insert;

import elki.data.ModifiableHyperBoundingBox;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.index.tree.spatial.rstarvariants.strategies.insert.LeastOverlapInsertionStrategy;
import elki.utilities.datastructures.arraylike.ArrayAdapter;
import elki.utilities.datastructures.heap.DoubleIntegerMinHeap;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class ApproximativeLeastOverlapInsertionStrategy
extends LeastOverlapInsertionStrategy {
    private int numCandidates = 32;

    public ApproximativeLeastOverlapInsertionStrategy(int candidates) {
        this.numCandidates = candidates;
    }

    @Override
    public <A> int choose(A options, ArrayAdapter<? extends SpatialComparable, A> getter, SpatialComparable obj, int height, int depth) {
        int size = getter.size(options);
        assert (size > 0) : "Choose from empty set?";
        if (size <= this.numCandidates) {
            return super.choose(options, getter, obj, height, depth);
        }
        DoubleIntegerMinHeap candidates = new DoubleIntegerMinHeap(this.numCandidates);
        for (int i = 0; i < size; ++i) {
            SpatialComparable entry = (SpatialComparable)getter.get(options, i);
            ModifiableHyperBoundingBox mbr = SpatialUtil.union((SpatialComparable)entry, (SpatialComparable)obj);
            double inc_area = SpatialUtil.volume((SpatialComparable)mbr) - SpatialUtil.volume((SpatialComparable)entry);
            candidates.add(inc_area, i, this.numCandidates);
        }
        int best = -1;
        double least_overlap = Double.POSITIVE_INFINITY;
        double least_areainc = Double.POSITIVE_INFINITY;
        double least_area = Double.POSITIVE_INFINITY;
        while (!candidates.isEmpty()) {
            double area;
            double inc_area = candidates.peekKey();
            int cand = candidates.peekValue();
            candidates.poll();
            SpatialComparable entry = (SpatialComparable)getter.get(options, cand);
            ModifiableHyperBoundingBox mbr = SpatialUtil.union((SpatialComparable)entry, (SpatialComparable)obj);
            double overlap_wout = 0.0;
            double overlap_with = 0.0;
            for (int k = 0; k < size; ++k) {
                if (cand == k) continue;
                SpatialComparable other = (SpatialComparable)getter.get(options, k);
                overlap_wout += SpatialUtil.relativeOverlap((SpatialComparable)entry, (SpatialComparable)other);
                overlap_with += SpatialUtil.relativeOverlap((SpatialComparable)mbr, (SpatialComparable)other);
            }
            double inc_overlap = overlap_with - overlap_wout;
            if (inc_overlap < least_overlap) {
                area = SpatialUtil.volume((SpatialComparable)entry);
                least_overlap = inc_overlap;
                least_areainc = inc_area;
                least_area = area;
                best = cand;
                continue;
            }
            if (inc_overlap != least_overlap) continue;
            area = SpatialUtil.volume((SpatialComparable)entry);
            if (!(inc_area < least_areainc) && (inc_area != least_areainc || !(area < least_area))) continue;
            least_overlap = inc_overlap;
            least_areainc = inc_area;
            least_area = area;
            best = cand;
        }
        assert (best > -1) : "No split found? Volume outside of double precision?";
        return best;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID INSERTION_CANDIDATES_ID = new OptionID("rtree.insertion-candidates", "defines how many children are tested for finding the child generating the least overlap when inserting an object.");
        int numCandidates = 32;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(INSERTION_CANDIDATES_ID, this.numCandidates).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.numCandidates = x;
            });
        }

        public ApproximativeLeastOverlapInsertionStrategy make() {
            return new ApproximativeLeastOverlapInsertionStrategy(this.numCandidates);
        }
    }
}

