/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.insert;

import elki.data.spatial.SpatialComparable;
import elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import elki.index.tree.spatial.rstarvariants.strategies.insert.LeastEnlargementWithAreaInsertionStrategy;
import elki.index.tree.spatial.rstarvariants.strategies.insert.LeastOverlapInsertionStrategy;
import elki.utilities.datastructures.arraylike.ArrayAdapter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassParameter;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class CombinedInsertionStrategy
implements InsertionStrategy {
    InsertionStrategy dirStrategy;
    InsertionStrategy leafStrategy;

    public CombinedInsertionStrategy(InsertionStrategy dirStrategy, InsertionStrategy leafStrategy) {
        this.dirStrategy = dirStrategy;
        this.leafStrategy = leafStrategy;
    }

    @Override
    public <A> int choose(A options, ArrayAdapter<? extends SpatialComparable, A> getter, SpatialComparable obj, int height, int depth) {
        if (depth + 1 >= height) {
            return this.leafStrategy.choose(options, getter, obj, height, depth);
        }
        return this.dirStrategy.choose(options, getter, obj, height, depth);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID DIR_STRATEGY_ID = new OptionID("rtree.insert-directory", "Insertion strategy for directory nodes.");
        public static final OptionID LEAF_STRATEGY_ID = new OptionID("rtree.insert-leaf", "Insertion strategy for leaf nodes.");
        InsertionStrategy dirStrategy;
        InsertionStrategy leafStrategy;

        public void configure(Parameterization config) {
            new ClassParameter(DIR_STRATEGY_ID, InsertionStrategy.class, LeastEnlargementWithAreaInsertionStrategy.class).grab(config, x -> {
                this.dirStrategy = x;
            });
            new ClassParameter(LEAF_STRATEGY_ID, InsertionStrategy.class, LeastOverlapInsertionStrategy.class).grab(config, x -> {
                this.leafStrategy = x;
            });
        }

        public CombinedInsertionStrategy make() {
            return new CombinedInsertionStrategy(this.dirStrategy, this.leafStrategy);
        }
    }
}

