/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.insert;

import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import elki.utilities.datastructures.arraylike.ArrayAdapter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="A. Guttman", title="R-Trees: A Dynamic Index Structure For Spatial Searching", booktitle="Proc. 1984 ACM SIGMOD Int. Conf. on Management of Data", url="https://doi.org/10.1145/971697.602266", bibkey="doi:10.1145/971697.602266")
public class LeastEnlargementInsertionStrategy
implements InsertionStrategy {
    public static final LeastEnlargementInsertionStrategy STATIC = new LeastEnlargementInsertionStrategy();

    @Override
    public <A> int choose(A options, ArrayAdapter<? extends SpatialComparable, A> getter, SpatialComparable obj, int height, int depth) {
        int size = getter.size(options);
        assert (size > 0) : "Choose from empty set?";
        double leastEnlargement = Double.POSITIVE_INFINITY;
        int best = -1;
        for (int i = 0; i < size; ++i) {
            SpatialComparable entry = (SpatialComparable)getter.get(options, i);
            double enlargement = SpatialUtil.enlargement((SpatialComparable)entry, (SpatialComparable)obj);
            if (!(enlargement < leastEnlargement)) continue;
            leastEnlargement = enlargement;
            best = i;
        }
        assert (best > -1);
        return best;
    }

    public static class Par
    implements Parameterizer {
        public LeastEnlargementInsertionStrategy make() {
            return STATIC;
        }
    }
}

