/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.insert;

import elki.data.ModifiableHyperBoundingBox;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import elki.utilities.datastructures.arraylike.ArrayAdapter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class LeastOverlapInsertionStrategy
implements InsertionStrategy {
    public static final LeastOverlapInsertionStrategy STATIC = new LeastOverlapInsertionStrategy();

    @Override
    public <A> int choose(A options, ArrayAdapter<? extends SpatialComparable, A> getter, SpatialComparable obj, int height, int depth) {
        int size = getter.size(options);
        assert (size > 0) : "Choose from empty set?";
        int best = -1;
        double least_overlap = Double.POSITIVE_INFINITY;
        double least_areainc = Double.POSITIVE_INFINITY;
        double least_area = Double.POSITIVE_INFINITY;
        for (int i = 0; i < size; ++i) {
            double inc_area;
            double area;
            SpatialComparable entry = (SpatialComparable)getter.get(options, i);
            ModifiableHyperBoundingBox mbr = SpatialUtil.union((SpatialComparable)entry, (SpatialComparable)obj);
            double overlap_wout = 0.0;
            double overlap_with = 0.0;
            for (int k = 0; k < size; ++k) {
                if (i == k) continue;
                SpatialComparable other = (SpatialComparable)getter.get(options, k);
                overlap_wout += SpatialUtil.relativeOverlap((SpatialComparable)entry, (SpatialComparable)other);
                overlap_with += SpatialUtil.relativeOverlap((SpatialComparable)mbr, (SpatialComparable)other);
            }
            double inc_overlap = overlap_with - overlap_wout;
            if (inc_overlap < least_overlap) {
                area = SpatialUtil.volume((SpatialComparable)entry);
                inc_area = SpatialUtil.volume((SpatialComparable)mbr) - area;
                least_overlap = inc_overlap;
                least_areainc = inc_area;
                least_area = area;
                best = i;
                continue;
            }
            if (inc_overlap != least_overlap) continue;
            area = SpatialUtil.volume((SpatialComparable)entry);
            inc_area = SpatialUtil.volume((SpatialComparable)mbr) - area;
            if (!(inc_area < least_areainc) && (inc_area != least_areainc || !(area < least_area))) continue;
            least_overlap = inc_overlap;
            least_areainc = inc_area;
            least_area = area;
            best = i;
        }
        assert (best > -1) : "No split found? Volume outside of double precision?";
        return best;
    }

    public static class Par
    implements Parameterizer {
        public LeastOverlapInsertionStrategy make() {
            return STATIC;
        }
    }
}

