/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.overflow;

import elki.distance.SpatialPrimitiveDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.index.tree.IndexTreePath;
import elki.index.tree.LeafEntry;
import elki.index.tree.spatial.SpatialEntry;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import elki.index.tree.spatial.rstarvariants.strategies.overflow.OverflowTreatment;
import elki.index.tree.spatial.rstarvariants.strategies.reinsert.CloseReinsert;
import elki.index.tree.spatial.rstarvariants.strategies.reinsert.ReinsertStrategy;
import elki.index.tree.spatial.rstarvariants.util.NodeArrayAdapter;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class LimitedReinsertOverflowTreatment
implements OverflowTreatment {
    public static final LimitedReinsertOverflowTreatment RSTAR_OVERFLOW = new LimitedReinsertOverflowTreatment(new CloseReinsert(0.3, (SpatialPrimitiveDistance<?>)SquaredEuclideanDistance.STATIC));
    private long[] reinsertions = new long[1];
    private final ReinsertStrategy reinsertStrategy;

    public LimitedReinsertOverflowTreatment(ReinsertStrategy reinsertStrategy) {
        this.reinsertStrategy = reinsertStrategy;
    }

    @Override
    public <N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry> boolean handleOverflow(AbstractRStarTree<N, E, ?> tree, N node, IndexTreePath<E> path) {
        int depthm1 = path.getPathCount() - 1;
        if (depthm1 == 0) {
            return false;
        }
        if (BitsUtil.capacity((long[])this.reinsertions) < depthm1) {
            this.reinsertions = BitsUtil.copy((long[])this.reinsertions, (int)depthm1);
        }
        if (BitsUtil.get((long[])this.reinsertions, (int)depthm1)) {
            return false;
        }
        BitsUtil.setI((long[])this.reinsertions, (int)depthm1);
        SpatialEntry entry = (SpatialEntry)path.getEntry();
        assert (!(entry instanceof LeafEntry)) : "Unexpected leaf entry";
        int[] cands = this.reinsertStrategy.computeReinserts(node, NodeArrayAdapter.STATIC, entry);
        if (cands == null || cands.length == 0) {
            return false;
        }
        tree.reInsert(node, path, cands);
        return true;
    }

    @Override
    public void reinitialize() {
        BitsUtil.zeroI((long[])this.reinsertions);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID REINSERT_STRATEGY_ID = new OptionID("rtree.reinsertion-strategy", "The strategy to select candidates for reinsertion.");
        ReinsertStrategy reinsertStrategy = null;

        public void configure(Parameterization config) {
            new ObjectParameter(REINSERT_STRATEGY_ID, ReinsertStrategy.class, CloseReinsert.class).grab(config, x -> {
                this.reinsertStrategy = x;
            });
        }

        public LimitedReinsertOverflowTreatment make() {
            return new LimitedReinsertOverflowTreatment(this.reinsertStrategy);
        }
    }
}

