/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.reinsert;

import elki.data.DoubleVector;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.distance.SpatialPrimitiveDistance;
import elki.index.tree.spatial.rstarvariants.strategies.reinsert.AbstractPartialReinsert;
import elki.math.MathUtil;
import elki.utilities.datastructures.arraylike.ArrayAdapter;
import elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;
import elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class CloseReinsert
extends AbstractPartialReinsert {
    public CloseReinsert(double reinsertAmount, SpatialPrimitiveDistance<?> distance) {
        super(reinsertAmount, distance);
    }

    @Override
    public <A> int[] computeReinserts(A entries, ArrayAdapter<? extends SpatialComparable, ? super A> getter, SpatialComparable page) {
        DoubleVector centroid = DoubleVector.wrap((double[])SpatialUtil.centroid((SpatialComparable)page));
        int size = getter.size(entries);
        double[] dist = new double[size];
        int[] idx = MathUtil.sequence((int)0, (int)size);
        for (int i = 0; i < size; ++i) {
            dist[i] = this.distance.minDist((SpatialComparable)DoubleVector.wrap((double[])SpatialUtil.centroid((SpatialComparable)((SpatialComparable)getter.get(entries, i)))), (SpatialComparable)centroid);
        }
        DoubleIntegerArrayQuickSort.sort((double[])dist, (int[])idx, (int)size);
        return Arrays.copyOf(idx, (int)(this.reinsertAmount * (double)size));
    }

    public static class Par
    extends AbstractPartialReinsert.Par {
        public CloseReinsert make() {
            return new CloseReinsert(this.reinsertAmount, this.distance);
        }
    }
}

