/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.split;

import elki.data.ModifiableHyperBoundingBox;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.datastructures.arraylike.ArrayAdapter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="A. Guttman", title="R-Trees: A Dynamic Index Structure For Spatial Searching", booktitle="Proc. 1984 ACM SIGMOD Int. Conf. on Management of Data", url="https://doi.org/10.1145/971697.602266", bibkey="doi:10.1145/971697.602266")
public class RTreeQuadraticSplit
implements SplitStrategy {
    public static final RTreeQuadraticSplit STATIC = new RTreeQuadraticSplit();

    @Override
    public <E extends SpatialComparable, A> long[] split(A entries, ArrayAdapter<E, A> getter, int minEntries) {
        SpatialComparable e1i;
        int e1;
        int num = getter.size(entries);
        long[] assignment = BitsUtil.zero((int)num);
        long[] assigned = BitsUtil.zero((int)num);
        double area1 = 0.0;
        double area2 = 0.0;
        double worst = Double.NEGATIVE_INFINITY;
        int w1 = 0;
        int w2 = 0;
        double[] areas = new double[num];
        for (e1 = 0; e1 < num - 1; ++e1) {
            e1i = (SpatialComparable)getter.get(entries, e1);
            areas[e1] = SpatialUtil.volume((SpatialComparable)e1i);
        }
        for (e1 = 0; e1 < num - 1; ++e1) {
            e1i = (SpatialComparable)getter.get(entries, e1);
            for (int e2 = e1 + 1; e2 < num; ++e2) {
                SpatialComparable e2i = (SpatialComparable)getter.get(entries, e2);
                double areaJ = SpatialUtil.volumeUnion((SpatialComparable)e1i, (SpatialComparable)e2i);
                double d = areaJ - areas[e1] - areas[e2];
                if (!(d > worst)) continue;
                worst = d;
                w1 = e1;
                w2 = e2;
            }
        }
        BitsUtil.setI((long[])assigned, (int)w1);
        BitsUtil.setI((long[])assigned, (int)w2);
        BitsUtil.setI((long[])assignment, (int)w2);
        area1 = areas[w1];
        area2 = areas[w2];
        ModifiableHyperBoundingBox mbr1 = new ModifiableHyperBoundingBox((SpatialComparable)getter.get(entries, w1));
        ModifiableHyperBoundingBox mbr2 = new ModifiableHyperBoundingBox((SpatialComparable)getter.get(entries, w2));
        int in1 = 1;
        int in2 = 1;
        int remaining = num - 2;
        while (remaining > 0 && in1 + remaining > minEntries) {
            if (in2 + remaining <= minEntries) {
                int pos = BitsUtil.nextClearBit((long[])assigned, (int)0);
                while (pos < num) {
                    BitsUtil.setI((long[])assignment, (int)pos);
                    pos = BitsUtil.nextClearBit((long[])assigned, (int)(pos + 1));
                }
                break;
            }
            double greatestPreference = Double.NEGATIVE_INFINITY;
            int best = -1;
            SpatialComparable best_i = null;
            boolean preferSecond = false;
            int pos = BitsUtil.nextClearBit((long[])assigned, (int)0);
            while (pos < num) {
                double d2;
                SpatialComparable pos_i = (SpatialComparable)getter.get(entries, pos);
                double d1 = SpatialUtil.volumeUnion((SpatialComparable)mbr1, (SpatialComparable)pos_i) - area1;
                double preference = Math.abs(d1 - (d2 = SpatialUtil.volumeUnion((SpatialComparable)mbr2, (SpatialComparable)pos_i) - area2));
                if (preference > greatestPreference) {
                    greatestPreference = preference;
                    best = pos;
                    best_i = pos_i;
                    preferSecond = d2 < d1;
                }
                pos = BitsUtil.nextClearBit((long[])assigned, (int)(pos + 1));
            }
            if (greatestPreference == 0.0) {
                preferSecond = area1 != area2 ? area2 < area1 : in2 < in1;
            }
            BitsUtil.setI((long[])assigned, (int)best);
            --remaining;
            if (!preferSecond) {
                ++in1;
                mbr1.extend(best_i);
                area1 = SpatialUtil.volume((SpatialComparable)mbr1);
                continue;
            }
            ++in2;
            BitsUtil.setI((long[])assignment, (int)best);
            mbr2.extend(best_i);
            area2 = SpatialUtil.volume((SpatialComparable)mbr2);
        }
        return assignment;
    }

    public static class Par
    implements Parameterizer {
        public RTreeQuadraticSplit make() {
            return STATIC;
        }
    }
}

