/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree.spatial.rstarvariants.strategies.split;

import elki.data.ModifiableHyperBoundingBox;
import elki.data.spatial.SpatialComparable;
import elki.data.spatial.SpatialUtil;
import elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.datastructures.arraylike.ArrayAdapter;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.pairs.DoubleIntPair;
import java.util.Arrays;

@Reference(authors="Norbert Beckmann, Hans-Peter Kriegel, Ralf Schneider, Bernhard Seeger", title="The R*-tree: an efficient and robust access method for points and rectangles", booktitle="Proc. 1990 ACM SIGMOD Int. Conf. Management of Data", url="https://doi.org/10.1145/93597.98741", bibkey="DBLP:conf/sigmod/BeckmannKSS90")
public class TopologicalSplitter
implements SplitStrategy {
    public static final TopologicalSplitter STATIC = new TopologicalSplitter();

    @Override
    public <E extends SpatialComparable, A> long[] split(A entries, ArrayAdapter<E, A> getter, int minEntries) {
        Split<A, E> split = new Split<A, E>(entries, getter);
        split.chooseSplitAxis(minEntries);
        split.chooseSplitPoint(minEntries);
        assert (split.splitPoint < ((Split)split).size) : "Invalid split produced. Size: " + getter.size(entries) + " minEntries: " + minEntries + " split.size: " + Split.access$000(split);
        long[] assignment = BitsUtil.zero((int)((Split)split).size);
        for (int i = split.splitPoint; i < ((Split)split).size; ++i) {
            BitsUtil.setI((long[])assignment, (int)split.bestSorting[i].second);
        }
        return assignment;
    }

    public static class Par
    implements Parameterizer {
        public TopologicalSplitter make() {
            return STATIC;
        }
    }

    private static class Split<A, E extends SpatialComparable> {
        int splitPoint = -1;
        DoubleIntPair[] bestSorting;
        DoubleIntPair[] maxSorting;
        DoubleIntPair[] minSorting;
        private A entries;
        private ArrayAdapter<E, A> getter;
        private int size;
        private int dimensionality;

        public Split(A entries, ArrayAdapter<E, A> getter) {
            this.entries = entries;
            this.getter = getter;
            this.size = getter.size(entries);
            this.dimensionality = ((SpatialComparable)getter.get(entries, 0)).getDimensionality();
            this.initMinMaxArrays();
        }

        void chooseSplitAxis(int minEntries) {
            double minSurface = Double.MAX_VALUE;
            int splitAxis = -1;
            for (int d = 0; d < this.dimensionality; ++d) {
                double sumOfAllMargins = 0.0;
                this.fillAndSort(d);
                ModifiableHyperBoundingBox mbr_min_left = new ModifiableHyperBoundingBox(this.get(this.minSorting[0]));
                ModifiableHyperBoundingBox mbr_min_right = new ModifiableHyperBoundingBox(this.get(this.minSorting[this.size - 1]));
                ModifiableHyperBoundingBox mbr_max_left = new ModifiableHyperBoundingBox(this.get(this.maxSorting[0]));
                ModifiableHyperBoundingBox mbr_max_right = new ModifiableHyperBoundingBox(this.get(this.maxSorting[this.size - 1]));
                for (int k = 1; k < this.size - minEntries; ++k) {
                    mbr_min_left.extend(this.get(this.minSorting[k]));
                    mbr_min_right.extend(this.get(this.minSorting[this.size - 1 - k]));
                    mbr_max_left.extend(this.get(this.maxSorting[k]));
                    mbr_max_right.extend(this.get(this.maxSorting[this.size - 1 - k]));
                    if (k < minEntries - 1) continue;
                    sumOfAllMargins += SpatialUtil.perimeter((SpatialComparable)mbr_min_left) + SpatialUtil.perimeter((SpatialComparable)mbr_min_right) + SpatialUtil.perimeter((SpatialComparable)mbr_max_left) + SpatialUtil.perimeter((SpatialComparable)mbr_max_right);
                }
                if (!(sumOfAllMargins < minSurface)) continue;
                splitAxis = d;
                minSurface = sumOfAllMargins;
            }
            if (splitAxis != this.dimensionality) {
                this.fillAndSort(splitAxis);
            }
        }

        protected void initMinMaxArrays() {
            this.maxSorting = new DoubleIntPair[this.size];
            this.minSorting = new DoubleIntPair[this.size];
            for (int j = 0; j < this.size; ++j) {
                this.minSorting[j] = new DoubleIntPair(0.0, -1);
                this.maxSorting[j] = new DoubleIntPair(0.0, -1);
            }
        }

        protected void fillAndSort(int dim) {
            for (int j = 0; j < this.size; ++j) {
                E e = this.get(j);
                this.minSorting[j].first = e.getMin(dim);
                this.minSorting[j].second = j;
                this.maxSorting[j].first = e.getMax(dim);
                this.maxSorting[j].second = j;
            }
            Arrays.sort(this.minSorting);
            Arrays.sort(this.maxSorting);
        }

        void chooseSplitPoint(int minEntries) {
            double vol;
            double currentOverlap;
            ModifiableHyperBoundingBox mbr2;
            int i;
            this.splitPoint = this.size;
            double minOverlap = Double.POSITIVE_INFINITY;
            double volume = Double.POSITIVE_INFINITY;
            this.bestSorting = null;
            assert (this.size - 2 * minEntries >= 0) : "Cannot split nodes (" + this.size + " < 2*" + minEntries + ")";
            ModifiableHyperBoundingBox mbr1 = this.mbr(this.minSorting, 0, minEntries - 1);
            for (i = 0; i <= this.size - 2 * minEntries; ++i) {
                mbr1.extend((SpatialComparable)this.getter.get(this.entries, this.minSorting[minEntries + i - 1].second));
                mbr2 = this.mbr(this.minSorting, minEntries + i, this.size);
                currentOverlap = SpatialUtil.relativeOverlap((SpatialComparable)mbr1, (SpatialComparable)mbr2);
                if (!(currentOverlap <= minOverlap)) continue;
                vol = SpatialUtil.volume((SpatialComparable)mbr1) + SpatialUtil.volume((SpatialComparable)mbr2);
                if (!(currentOverlap < minOverlap) && !(vol < volume)) continue;
                minOverlap = currentOverlap;
                volume = vol;
                this.splitPoint = minEntries + i;
                this.bestSorting = this.minSorting;
            }
            mbr1 = this.mbr(this.maxSorting, 0, minEntries - 1);
            for (i = 0; i <= this.size - 2 * minEntries; ++i) {
                mbr1.extend((SpatialComparable)this.getter.get(this.entries, this.maxSorting[minEntries + i - 1].second));
                mbr2 = this.mbr(this.maxSorting, minEntries + i, this.size);
                currentOverlap = SpatialUtil.relativeOverlap((SpatialComparable)mbr1, (SpatialComparable)mbr2);
                if (!(currentOverlap <= minOverlap)) continue;
                vol = SpatialUtil.volume((SpatialComparable)mbr1) + SpatialUtil.volume((SpatialComparable)mbr2);
                if (!(currentOverlap < minOverlap) && !(vol < volume)) continue;
                minOverlap = currentOverlap;
                volume = vol;
                this.splitPoint = minEntries + i;
                this.bestSorting = this.maxSorting;
            }
            assert (this.splitPoint < this.size) : "No split found? Volume outside of double precision?";
        }

        private E get(int off) {
            return (E)((SpatialComparable)this.getter.get(this.entries, off));
        }

        private E get(DoubleIntPair pair) {
            return (E)((SpatialComparable)this.getter.get(this.entries, pair.second));
        }

        private ModifiableHyperBoundingBox mbr(DoubleIntPair[] sorting, int from, int to) {
            ModifiableHyperBoundingBox mbr = new ModifiableHyperBoundingBox(this.get(sorting[from]));
            for (int i = from + 1; i < to; ++i) {
                mbr.extend(this.get(sorting[i]));
            }
            return mbr;
        }
    }
}

