/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree;

import elki.index.tree.DirectoryEntry;
import elki.index.tree.IndexTree;
import elki.index.tree.IndexTreePath;
import elki.index.tree.Node;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class BreadthFirstEnumeration<N extends Node<E>, E>
implements Iterator<IndexTreePath<E>> {
    public final Iterator<IndexTreePath<E>> EMPTY_ENUMERATION = new Iterator<IndexTreePath<E>>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public IndexTreePath<E> next() {
            throw new NoSuchElementException("No more children");
        }
    };
    private Queue<Iterator<IndexTreePath<E>>> queue = new LinkedList<Iterator<IndexTreePath<E>>>();
    private IndexTree<N, E> index;

    public BreadthFirstEnumeration(IndexTree<N, E> index, final IndexTreePath<E> rootPath) {
        this.index = index;
        Iterator root_enum = new Iterator<IndexTreePath<E>>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public IndexTreePath<E> next() {
                this.hasNext = false;
                return rootPath;
            }
        };
        this.queue.offer(root_enum);
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty() && this.queue.peek().hasNext();
    }

    @Override
    public IndexTreePath<E> next() {
        Iterator<IndexTreePath<E>> children;
        E ent;
        Iterator<IndexTreePath<E>> enumeration = this.queue.peek();
        IndexTreePath<E> nextPath = enumeration.next();
        if (!enumeration.hasNext()) {
            this.queue.remove();
        }
        if ((ent = nextPath.getEntry()) instanceof DirectoryEntry && (children = this.index.getNode(ent).children(nextPath)).hasNext()) {
            this.queue.offer(children);
        }
        return nextPath;
    }
}

