/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree;

import elki.persistent.DefaultPageHeader;
import elki.utilities.datastructures.arraylike.IntegerArray;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class TreeIndexHeader
extends DefaultPageHeader {
    private static int SIZE = 24;
    int dirCapacity;
    int leafCapacity;
    int dirMinimum;
    int leafMinimum;
    private int emptyPagesSize = 0;
    private int largestPageID = 0;

    public TreeIndexHeader() {
    }

    public TreeIndexHeader(int pageSize, int dirCapacity, int leafCapacity, int dirMinimum, int leafMinimum) {
        super(pageSize);
        this.dirCapacity = dirCapacity;
        this.leafCapacity = leafCapacity;
        this.dirMinimum = dirMinimum;
        this.leafMinimum = leafMinimum;
    }

    @Override
    public void readHeader(ByteBuffer buffer) {
        super.readHeader(buffer);
        this.dirCapacity = buffer.getInt();
        this.leafCapacity = buffer.getInt();
        this.dirMinimum = buffer.getInt();
        this.leafMinimum = buffer.getInt();
        this.emptyPagesSize = buffer.getInt();
        this.largestPageID = buffer.getInt();
    }

    @Override
    public void writeHeader(ByteBuffer buffer) {
        super.writeHeader(buffer);
        buffer.putInt(this.dirCapacity).putInt(this.leafCapacity).putInt(this.dirMinimum).putInt(this.leafMinimum).putInt(this.emptyPagesSize).putInt(this.largestPageID).flip();
    }

    public int getDirCapacity() {
        return this.dirCapacity;
    }

    public int getLeafCapacity() {
        return this.leafCapacity;
    }

    public int getDirMinimum() {
        return this.dirMinimum;
    }

    public int getLeafMinimum() {
        return this.leafMinimum;
    }

    public int getEmptyPagesSize() {
        return this.emptyPagesSize;
    }

    public void setEmptyPagesSize(int emptyPagesSize) {
        this.emptyPagesSize = emptyPagesSize;
    }

    public int getLargestPageID() {
        return this.largestPageID;
    }

    public void setLargestPageID(int largestPageID) {
        this.largestPageID = largestPageID;
    }

    @Override
    public int size() {
        return super.size() + SIZE;
    }

    public void writeEmptyPages(IntegerArray emptyPages, FileChannel file) throws IOException {
        if (emptyPages.isEmpty()) {
            this.emptyPagesSize = 0;
            return;
        }
        emptyPages.sort();
        this.emptyPagesSize = emptyPages.size * 4;
        ByteBuffer buf = ByteBuffer.allocateDirect(this.emptyPagesSize);
        buf.asIntBuffer().put(emptyPages.data, 0, emptyPages.size);
        file.write(buf, file.size());
    }

    public IntegerArray readEmptyPages(FileChannel file) throws IOException, ClassNotFoundException {
        IntegerArray emptyPages = new IntegerArray();
        if (this.emptyPagesSize > 0) {
            int n = this.emptyPagesSize / 4;
            if (n > emptyPages.data.length) {
                emptyPages.data = new int[n];
            }
            ByteBuffer buf = ByteBuffer.allocateDirect(this.emptyPagesSize);
            file.read(buf, file.size() - (long)this.emptyPagesSize);
            buf.asIntBuffer().get(emptyPages.data, 0, n);
        }
        return emptyPages;
    }
}

