/*
 * Decompiled with CFR 0.152.
 */
package elki.persistent;

import elki.persistent.PageHeader;
import java.nio.ByteBuffer;

public class DefaultPageHeader
implements PageHeader {
    private static final int SIZE = 8;
    private static final int FILE_VERSION = 841150978;
    private int pageSize = -1;

    public DefaultPageHeader() {
    }

    public DefaultPageHeader(int pageSize) {
        this.pageSize = pageSize;
    }

    public int size() {
        return 8;
    }

    public void readHeader(ByteBuffer data) {
        if (data.getInt() != 841150978) {
            throw new RuntimeException("PersistentPageFile version does not match!");
        }
        this.pageSize = data.getInt();
    }

    public void writeHeader(ByteBuffer buffer) {
        buffer.putInt(841150978).putInt(this.pageSize);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getReservedPages() {
        return this.size() / this.getPageSize() + 1;
    }
}

