/*
 * Decompiled with CFR 0.152.
 */
package elki.application;

import elki.application.AbstractApplication;
import elki.datasource.DatabaseConnection;
import elki.datasource.FileBasedDatabaseConnection;
import elki.datasource.bundle.BundleWriter;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.logging.Logging;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class ConvertToBundleApplication
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(ConvertToBundleApplication.class);
    private DatabaseConnection input;
    private Path outfile;

    public ConvertToBundleApplication(DatabaseConnection input, Path outfile) {
        this.input = input;
        this.outfile = outfile;
    }

    public void run() {
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)"Loading data.");
        }
        MultipleObjectsBundle bundle = this.input.loadData();
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)("Serializing to output file: " + this.outfile.toString()));
        }
        try (FileChannel channel = FileChannel.open(this.outfile, StandardOpenOption.WRITE);){
            new BundleWriter().writeBundleStream(bundle.asStream(), (WritableByteChannel)channel);
        }
        catch (IOException e) {
            LOG.exception((CharSequence)"IO Error", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        ConvertToBundleApplication.runCLIApplication(ConvertToBundleApplication.class, (String[])args);
    }

    public static class Par
    extends AbstractApplication.Par {
        public static final OptionID DATABASE_CONNECTION_ID = new OptionID("dbc", "Database connection class.");
        private DatabaseConnection input;
        private Path outfile;

        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(DATABASE_CONNECTION_ID, DatabaseConnection.class, FileBasedDatabaseConnection.class).grab(config, x -> {
                this.input = x;
            });
            this.outfile = super.getParameterOutputFile(config, "File name to serialize the bundle to.");
        }

        public ConvertToBundleApplication make() {
            return new ConvertToBundleApplication(this.input, this.outfile);
        }
    }
}

