/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.datasource.DatabaseConnection;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.datasource.filter.StreamFilter;
import elki.datasource.parser.Parser;
import elki.logging.Logging;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public abstract class AbstractDatabaseConnection
implements DatabaseConnection {
    public static final String LABEL_CONCATENATION = " ";
    protected List<? extends ObjectFilter> filters;

    protected AbstractDatabaseConnection(List<? extends ObjectFilter> filters) {
        this.filters = filters;
    }

    protected MultipleObjectsBundle invokeBundleFilters(MultipleObjectsBundle bundle) {
        assert (bundle != null);
        if (this.filters == null) {
            return bundle;
        }
        BundleStreamSource stream = null;
        for (ObjectFilter objectFilter : this.filters) {
            if (objectFilter instanceof StreamFilter) {
                stream = ((StreamFilter)objectFilter).init(bundle != null ? bundle.asStream() : stream);
                bundle = null;
                continue;
            }
            bundle = objectFilter.filter(stream != null ? stream.asMultipleObjectsBundle() : bundle);
            stream = null;
        }
        return bundle != null ? bundle : stream.asMultipleObjectsBundle();
    }

    protected BundleStreamSource invokeStreamFilters(BundleStreamSource stream) {
        assert (stream != null);
        if (this.filters == null) {
            return stream;
        }
        MultipleObjectsBundle bundle = null;
        for (ObjectFilter objectFilter : this.filters) {
            if (objectFilter instanceof StreamFilter) {
                stream = ((StreamFilter)objectFilter).init(bundle != null ? bundle.asStream() : stream);
                bundle = null;
                continue;
            }
            bundle = objectFilter.filter(stream != null ? stream.asMultipleObjectsBundle() : bundle);
            stream = null;
        }
        return stream != null ? stream : bundle.asStream();
    }

    protected abstract Logging getLogger();

    public static abstract class Par
    implements Parameterizer {
        public static final OptionID FILTERS_ID = new OptionID("dbc.filter", "The filters to apply to the input data.");
        public static final OptionID PARSER_ID = new OptionID("dbc.parser", "Parser to provide the database.");
        protected List<? extends ObjectFilter> filters;
        protected Parser parser = null;

        protected void configFilters(Parameterization config) {
            new ObjectListParameter(FILTERS_ID, ObjectFilter.class).setOptional(true).grab(config, x -> {
                this.filters = x;
            });
        }

        protected void configParser(Parameterization config, Class<?> parserRestrictionClass, Class<?> parserDefaultValueClass) {
            new ObjectParameter(PARSER_ID, parserRestrictionClass, parserDefaultValueClass).grab(config, x -> {
                this.parser = x;
            });
        }
    }
}

