/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.data.DoubleVector;
import elki.data.FeatureVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDFactory;
import elki.datasource.AbstractDatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayAdapterDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(ArrayAdapterDatabaseConnection.class);
    double[][] data;
    String[] labels;
    Integer startid = null;

    public ArrayAdapterDatabaseConnection(double[][] data) {
        this(data, null, null, null);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, List<ObjectFilter> filters) {
        this(data, null, null, filters);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, String[] labels) {
        this(data, labels, null, null);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, String[] labels, List<ObjectFilter> filters) {
        this(data, labels, null, filters);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, String[] labels, Integer startid) {
        this(data, labels, startid, null);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, String[] labels, Integer startid, List<ObjectFilter> filters) {
        super(filters);
        this.data = data;
        this.labels = labels;
        this.startid = startid;
    }

    public MultipleObjectsBundle loadData() {
        MultipleObjectsBundle b = new MultipleObjectsBundle();
        if (this.startid != null) {
            b.setDBIDs((ArrayDBIDs)DBIDFactory.FACTORY.generateStaticDBIDRange(this.startid.intValue(), this.data.length));
        }
        int mind = Integer.MAX_VALUE;
        int maxd = 0;
        ArrayList<DoubleVector> vecs = new ArrayList<DoubleVector>(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            int d = this.data[i].length;
            mind = d < mind ? d : mind;
            maxd = d > maxd ? d : maxd;
            vecs.add(DoubleVector.wrap((double[])this.data[i]));
        }
        VectorFieldTypeInformation type = new VectorFieldTypeInformation((FeatureVector.Factory)DoubleVector.FACTORY, mind, maxd, DoubleVector.FACTORY.getDefaultSerializer());
        b.appendColumn((SimpleTypeInformation)type, vecs);
        if (this.labels != null) {
            if (this.labels.length != this.data.length) {
                throw new AbortException("Label and DBID columns must have the same size.");
            }
            b.appendColumn(TypeUtil.STRING, Arrays.asList(this.labels));
        }
        return this.invokeBundleFilters(b);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

