/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.datasource.AbstractDatabaseConnection;
import elki.datasource.bundle.BundleReader;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class BundleDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(BundleDatabaseConnection.class);
    private Path infile;

    public BundleDatabaseConnection(List<? extends ObjectFilter> filters, Path infile) {
        super(filters);
        this.infile = infile;
    }

    public MultipleObjectsBundle loadData() {
        MultipleObjectsBundle multipleObjectsBundle;
        block8: {
            FileChannel channel = FileChannel.open(this.infile, new OpenOption[0]);
            try {
                multipleObjectsBundle = this.invokeStreamFilters((BundleStreamSource)new BundleReader(channel)).asMultipleObjectsBundle();
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AbortException("IO error loading bundle", (Throwable)e);
                }
            }
            channel.close();
        }
        return multipleObjectsBundle;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabaseConnection.Par {
        private static final OptionID BUNDLE_ID = new OptionID("bundle.input", "Bundle file to load the data from.");
        private Path infile;

        public void configure(Parameterization config) {
            super.configure(config);
            this.configFilters(config);
            new FileParameter(BUNDLE_ID, FileParameter.FileType.INPUT_FILE).grab(config, x -> {
                this.infile = Paths.get(x);
            });
        }

        public BundleDatabaseConnection make() {
            return new BundleDatabaseConnection(this.filters, this.infile);
        }
    }
}

